/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.autoconfiguration.FilestoreS3Properties;
import jp.jasminesoft.jfc.job.FileProcessTask;
import jp.jasminesoft.jfc.job.TaskException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class AmazonS3UploadTask
extends FileProcessTask {
    private static final Logger logger = LogManager.getLogger((String)AmazonS3UploadTask.class.getName());
    protected JobParam jPrm = new JobParam();
    protected S3Client s3;
    protected String s3folder;
    protected List<File> deleteFileList = new ArrayList<File>();
    protected List<File> processedFileObjList = new ArrayList<File>();

    protected S3Client createS3Client() {
        S3Client s3;
        if (!this.jPrm.isParamsOk()) {
            throw new TaskException("Need to check parameter.");
        }
        if (this.jPrm.isHaveCredentials() || StringUtils.isNotBlank((CharSequence)this.jPrm.getProxyHost())) {
            S3ClientBuilder builder = S3Client.builder();
            builder = this.setBuilderSetting(builder);
            s3 = (S3Client)builder.build();
        } else {
            s3 = S3Client.create();
        }
        if (this.jPrm.isShowS3Owner()) {
            this.showS3Owner(s3, this.jPrm.getBucket());
        }
        return s3;
    }

    @Override
    public String execute(ActionParameter p) {
        try {
            String string;
            block9: {
                S3Client s3 = this.createS3Client();
                try {
                    this.s3 = s3;
                    this.s3folder = this.getS3folder(this.jPrm);
                    string = super.execute(p);
                    if (s3 == null) break block9;
                }
                catch (Throwable throwable) {
                    if (s3 != null) {
                        try {
                            s3.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                s3.close();
            }
            return string;
        }
        finally {
            this.s3 = null;
            this.s3folder = null;
        }
    }

    private <T extends AwsClientBuilder<T, ?>> T setBuilderSetting(T builder) {
        if (this.jPrm.isHaveCredentials()) {
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)this.jPrm.getAccessKey(), (String)this.jPrm.getSecretKey());
            Region region = StringUtils.isBlank((CharSequence)this.jPrm.getRegion()) ? Region.AP_NORTHEAST_1 : Region.of((String)this.jPrm.getRegion());
            builder = builder.region(region).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials));
        }
        if (StringUtils.isNotBlank((CharSequence)this.jPrm.getProxyHost()) && builder instanceof SdkSyncClientBuilder) {
            try {
                URI proxyEndpoind = new URI("http", null, this.jPrm.getProxyHost(), this.jPrm.getProxyPort(), null, null, null);
                ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder().endpoint(proxyEndpoind);
                if (StringUtils.isNotBlank((CharSequence)this.jPrm.getProxyUser())) {
                    proxyConfigBuilder = proxyConfigBuilder.username(this.jPrm.getProxyUser()).password(this.jPrm.getProxyPassword());
                }
                AwsClientBuilder builder1 = (AwsClientBuilder)((SdkSyncClientBuilder)builder).httpClient(ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfigBuilder.build()).build());
                builder = builder1;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return builder;
    }

    @Override
    protected boolean isIgnoreZeroSizeFile() {
        return true;
    }

    public void setJobParamAmazonS3Upload(Map<String, Object> dataMap) {
        this.jPrm.setRegion((String)dataMap.get("region"));
        this.jPrm.setAccessKey((String)dataMap.get("access_key"));
        this.jPrm.setSecretKey((String)dataMap.get("secret_key"));
        this.jPrm.setBucket((String)dataMap.get("bucket"));
        this.jPrm.setS3folder((String)dataMap.get("s3folder"));
        this.jPrm.setProxyHost((String)dataMap.get("proxy_host"));
        if (dataMap.containsKey("proxy_port")) {
            this.jPrm.setProxyPort(AmazonS3UploadTask.getIntValue(dataMap.get("proxy_port")));
        }
        this.jPrm.setProxyUser((String)dataMap.get("proxy_user"));
        this.jPrm.setProxyPassword((String)dataMap.get("proxy_password"));
        if (dataMap.containsKey("test_mode")) {
            this.jPrm.setTestMode(AmazonS3UploadTask.getBoolean(dataMap.get("test_mode")));
        }
        if (dataMap.containsKey("show_s3_owner")) {
            this.jPrm.setShowS3Owner(AmazonS3UploadTask.getBoolean(dataMap.get("show_s3_owner")));
        }
        if (dataMap.containsKey("delete_processed_files")) {
            this.jPrm.setDeleteProcessedFiles(AmazonS3UploadTask.getBoolean(dataMap.get("delete_processed_files")));
        }
        if (dataMap.containsKey("put_empty_at_create_directory")) {
            this.jPrm.setPutEmptyAtCreateDirectory(AmazonS3UploadTask.getBoolean(dataMap.get("put_empty_at_create_directory")));
        }
        KeySetting keySetting = this.jPrm.getDefaultKeySetting();
        if (dataMap.containsKey("overwrite")) {
            keySetting.setOverwrite(AmazonS3UploadTask.getBoolean(dataMap.get("overwrite")));
        }
        if (dataMap.containsKey("delete_file_for_exists_object")) {
            keySetting.setDeleteFileForExistsObject(AmazonS3UploadTask.getBoolean(dataMap.get("delete_file_for_exists_object")));
        }
        if (dataMap.containsKey("upload_file_interval")) {
            keySetting.setUploadFileInterval(Long.parseLong((String)dataMap.get("upload_file_interval")));
        }
    }

    public JobParam getJobParam() {
        return this.jPrm;
    }

    private static Boolean getBoolean(Object s) {
        if (s instanceof Boolean) {
            return (Boolean)s;
        }
        return Boolean.valueOf((String)s);
    }

    private static Integer getIntValue(Object s) {
        if (s instanceof Integer) {
            return (Integer)s;
        }
        return Integer.valueOf((String)s);
    }

    protected KeySetting getKeySetting(String key) {
        KeySettingCreator creator = this.jPrm.getKeySettingCreator();
        if (creator == null) {
            return this.jPrm.getDefaultKeySetting();
        }
        return creator.get(key);
    }

    protected String getS3folder(JobParam jPrm) {
        String s3folder = jPrm.getS3folder();
        if (s3folder == null) {
            s3folder = "";
        }
        String dateStr = AmazonS3UploadTask.getDateString();
        if (s3folder.contains("${DATE}")) {
            s3folder = s3folder.replaceAll("\\$\\{DATE\\}", dateStr);
        }
        String datetimeStr = AmazonS3UploadTask.getDatetimeString();
        if (s3folder.contains("${DATETIME}")) {
            s3folder = s3folder.replaceAll("\\$\\{DATETIME\\}", datetimeStr);
        }
        return s3folder;
    }

    protected boolean existsObject(String key) {
        return this.headObject(key) != null;
    }

    protected HeadObjectResponse headObject(String key) {
        try {
            HeadObjectResponse resp = this.s3.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.jPrm.getBucket()).key(key).range("0-128").build());
            logger.info("object " + key + " exists.");
            logger.debug("lastModified " + resp.lastModified());
            logger.debug("size " + resp.contentLength());
            return resp;
        }
        catch (NoSuchKeyException e) {
            logger.debug("object " + key + " doesn't exist.");
        }
        catch (Exception e) {
            logger.error("failed headObject " + key, (Throwable)e);
        }
        return null;
    }

    private boolean isSameFile(File f, HeadObjectResponse headObjectResp) {
        logger.debug("f.length " + f.length());
        logger.debug("headObjectResp.contentLength() " + headObjectResp.contentLength());
        return f.length() == headObjectResp.contentLength().longValue();
    }

    protected void uploadFile(File f) {
        HeadObjectResponse headObjectResp;
        boolean checkExistsObject;
        String s3path = this.getS3Path(f);
        KeySetting keySetting = this.getKeySetting(s3path);
        long uploadFileInterval = keySetting.getUploadFileInterval();
        if (uploadFileInterval > 0L && f.lastModified() + uploadFileInterval > System.currentTimeMillis()) {
            return;
        }
        boolean isDeleteFileForExistsObject = keySetting.isDeleteFileForExistsObject();
        boolean isOverwrite = keySetting.isOverwrite();
        String key = this.getS3KeyString(s3path);
        logger.debug("jPrm.isDeleteFileForExistsObject() " + isDeleteFileForExistsObject);
        if (this.jPrm.isTestMode()) {
            logger.info("test mode. not upload " + f.getPath() + " as " + key);
            return;
        }
        boolean bl = checkExistsObject = !isOverwrite || isDeleteFileForExistsObject;
        if (checkExistsObject && (headObjectResp = this.headObject(key)) != null) {
            if (!isOverwrite) {
                logger.info("object " + key + " exists. not upload");
                return;
            }
            if (isDeleteFileForExistsObject) {
                if (!this.isSameFile(f, headObjectResp)) {
                    logger.info("local file " + f + " and s3 file " + key + " is not same. local file length is " + f.length() + ". s3 file length is " + headObjectResp.contentLength());
                } else {
                    if (!f.delete()) {
                        logger.error("Failed delete local file " + f);
                        this.errorFileList.add(key);
                        return;
                    }
                    logger.info("Delete local file " + f);
                    this.deleteFileList.add(f);
                    return;
                }
            }
        }
        try {
            logger.info("upload " + f.getPath() + " as " + key);
            this.s3.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.jPrm.getBucket()).key(key).build(), RequestBody.fromFile((File)f));
            this.processedFileObjList.add(f);
            this.processedFileList.add(key);
        }
        catch (Exception e) {
            logger.debug("failed putObject for uploadFile " + s3path, (Throwable)e);
            this.errorFileList.add(key);
        }
    }

    protected void makeDirectory(String s3path) {
        KeySetting keySetting = this.getKeySetting(s3path);
        boolean isOverwrite = keySetting.isOverwrite();
        String key = this.getS3KeyString(s3path);
        logger.info("make directory " + key);
        if (this.jPrm.isTestMode()) {
            logger.info("test mode. not make dir");
        }
        boolean okWrite = true;
        if (!isOverwrite && this.existsObject(key)) {
            logger.debug("object " + key + " exists.");
            okWrite = false;
        }
        try {
            if (okWrite) {
                this.s3.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.jPrm.getBucket()).key(key).build(), RequestBody.empty());
                this.processedFileList.add(key);
            }
        }
        catch (Exception e) {
            logger.debug("failed putObject for makeDirectory " + s3path, (Throwable)e);
            this.errorFileList.add(key);
        }
    }

    private String getS3KeyString(String fileName) {
        if (StringUtils.isBlank((CharSequence)this.s3folder)) {
            return fileName;
        }
        return this.s3folder + "/" + fileName;
    }

    public static String getDateString() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date());
    }

    public static String getDatetimeString() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    protected void showS3Owner(S3Client s3, String bucket) {
        GetBucketAclResponse resp = s3.getBucketAcl((GetBucketAclRequest)GetBucketAclRequest.builder().bucket(bucket).build());
        Owner owner = resp.owner();
        if (owner != null) {
            logger.info("S3 owner:" + owner);
        } else {
            logger.warn("Failed to get owner info");
        }
    }

    protected String getS3Path(File file) {
        String s3path = this.getFilenameWithoutBaseDirectory(file);
        s3path = s3path.replace('\\', '/');
        return s3path;
    }

    @Override
    protected boolean processDirectory(File file) {
        if (file != null && file.isDirectory() && file.listFiles().length == 0 && this.jPrm.isPutEmptyAtCreateDirectory()) {
            this.makeDirectory(this.getS3Path(file));
        }
        return super.processDirectory(file);
    }

    @Override
    protected boolean processFile(File file) {
        this.uploadFile(file);
        return true;
    }

    @Override
    protected void finish() {
        if (this.jPrm.isDeleteProcessedFiles()) {
            for (File f : this.processedFileObjList) {
                logger.debug("delete processed file " + f);
                if (f.isFile()) {
                    if (!f.delete()) {
                        logger.error("Failed delete local file " + f);
                        String s3path = this.getS3Path(f);
                        String key = this.getS3KeyString(s3path);
                        this.errorFileList.add(key);
                        continue;
                    }
                    logger.info("Delete local file " + f);
                    this.deleteFileList.add(f);
                    continue;
                }
                logger.warn("Not found " + f);
            }
        }
        super.finish();
    }

    @Override
    protected String createMessage() {
        String classname = this.getClass().getName();
        StringBuilder sb = new StringBuilder();
        sb.append(classname).append(" is finished.");
        sb.append(" upload local to s3 file is " + this.processedFileList.size());
        sb.append(", delete local file is " + this.deleteFileList.size());
        sb.append(", error file is " + this.errorFileList.size());
        sb.append(CR);
        if (this.isDebug()) {
            if (this.totalCount > 0 && this.totalCount > this.errorCount) {
                sb.append("Success file list is below:").append(CR);
                for (String s : this.processedFileList) {
                    sb.append(" ").append(s).append(CR);
                }
            }
            if (this.errorCount > 0) {
                sb.append("Error file list is below:").append(CR);
                for (String s : this.errorFileList) {
                    sb.append(" ").append(s).append(CR);
                }
            }
        }
        return sb.toString();
    }

    public static class JobParam {
        protected String region;
        protected String accessKey;
        protected String secretKey;
        protected String bucket;
        protected String s3folder;
        protected String proxyHost;
        protected int proxyPort = -1;
        protected String proxyUser;
        protected String proxyPassword;
        protected boolean testMode;
        protected boolean isShowS3Owner = false;
        protected boolean isDeleteProcessedFiles = false;
        protected boolean isPutEmptyAtCreateDirectory = true;
        protected KeySettingCreator keySettingCreator;
        protected KeySetting defaultKeySetting = new KeySetting();

        boolean isHaveCredentials() {
            return !StringUtils.isBlank((CharSequence)this.accessKey) && !StringUtils.isBlank((CharSequence)this.secretKey);
        }

        boolean isParamsOk() {
            boolean isFatal = false;
            if (StringUtils.isBlank((CharSequence)this.accessKey) && StringUtils.isNotBlank((CharSequence)this.secretKey)) {
                logger.info("Job Parameter access_key is nessary if secret_key is set.");
                isFatal = true;
            }
            if (StringUtils.isBlank((CharSequence)this.secretKey) && StringUtils.isNotBlank((CharSequence)this.accessKey)) {
                logger.info("Job Parameter secret_key is nessary if access_key is set.");
                isFatal = true;
            }
            if (StringUtils.isBlank((CharSequence)this.bucket)) {
                logger.info("Job Parameter bucket is nessary.");
                isFatal = true;
            }
            if (StringUtils.isNotBlank((CharSequence)this.proxyHost) && this.proxyPort < 0) {
                logger.info("Job Parameter proxy_port is nessary if proxy_host is set.");
                isFatal = true;
            }
            if (StringUtils.isNotBlank((CharSequence)this.proxyUser) && StringUtils.isBlank((CharSequence)this.proxyPassword)) {
                logger.info("Job Parameter proxy_password is nessary if proxy_user is set.");
                isFatal = true;
            }
            if (StringUtils.isBlank((CharSequence)this.proxyUser) && StringUtils.isNotBlank((CharSequence)this.proxyPassword)) {
                logger.info("Job Parameter proxy_user is nessary if proxy_password is set.");
                isFatal = true;
            }
            if (this.testMode) {
                logger.info("This job runs as test mode.");
            }
            return !isFatal;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getS3folder() {
            return this.s3folder;
        }

        public void setS3folder(String s3folder) {
            this.s3folder = s3folder;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getBucket() {
            return this.bucket;
        }

        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
        }

        public String getProxyUser() {
            return this.proxyUser;
        }

        public void setProxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
        }

        public String getProxyPassword() {
            return this.proxyPassword;
        }

        public void setProxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
        }

        public boolean isTestMode() {
            return this.testMode;
        }

        public void setTestMode(boolean testMode) {
            this.testMode = testMode;
        }

        public boolean isShowS3Owner() {
            return this.isShowS3Owner;
        }

        public void setShowS3Owner(boolean isShowS3Owner) {
            this.isShowS3Owner = isShowS3Owner;
        }

        protected boolean isDeleteProcessedFiles() {
            return this.isDeleteProcessedFiles;
        }

        protected void setDeleteProcessedFiles(boolean b) {
            this.isDeleteProcessedFiles = b;
        }

        public boolean isPutEmptyAtCreateDirectory() {
            return this.isPutEmptyAtCreateDirectory;
        }

        public void setPutEmptyAtCreateDirectory(boolean b) {
            this.isPutEmptyAtCreateDirectory = b;
        }

        public KeySettingCreator getKeySettingCreator() {
            return this.keySettingCreator;
        }

        public void setKeySettingCreator(KeySettingCreator keySettingCreator) {
            this.keySettingCreator = keySettingCreator;
        }

        public void setDefaultKeySetting(KeySetting defaultKeySetting) {
            this.defaultKeySetting = defaultKeySetting;
        }

        public KeySetting getDefaultKeySetting() {
            return this.defaultKeySetting;
        }
    }

    public static class KeySetting {
        protected boolean overwrite = true;
        protected boolean deleteFileForExistsObject = false;
        protected long uploadFileInterval = 0L;

        public void set(FilestoreS3Properties.KeySettingImpl keySetting) {
            this.overwrite = keySetting.isOverwrite();
            this.deleteFileForExistsObject = keySetting.isDeletefileforexistsobject();
            this.uploadFileInterval = keySetting.getUploadfileinterval();
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean isOverwrite) {
            this.overwrite = isOverwrite;
        }

        public boolean isDeleteFileForExistsObject() {
            return this.deleteFileForExistsObject;
        }

        public void setDeleteFileForExistsObject(boolean b) {
            this.deleteFileForExistsObject = b;
        }

        public long getUploadFileInterval() {
            return this.uploadFileInterval;
        }

        public void setUploadFileInterval(long l) {
            this.uploadFileInterval = l;
        }
    }

    public static interface KeySettingCreator {
        public KeySetting get(String var1);
    }
}

