/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.service.RecalcService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class DataMaintenanceTask {
    protected static final String CR = System.getProperty("line.separator");
    private static final Logger logger = LogManager.getLogger((String)DataMaintenanceTask.class.getName());
    private String[] targetModelIds;

    public String[] getTargetModelIds() {
        return this.targetModelIds;
    }

    public void setTargetModelIds(String[] targetModelIds) {
        this.targetModelIds = targetModelIds;
    }

    public String execute(ActionParameter p) {
        if (ArrayUtils.isEmpty((Object[])this.targetModelIds)) {
            return "No target model.";
        }
        Object manager = p.appctx.getBean("JFCDataMaintenanceManager");
        StringBuilder sb = new StringBuilder();
        for (String targetModelId : this.targetModelIds) {
            String msg = this.execute0(targetModelId, p);
            System.out.println("msg=" + msg);
            if (!StringUtils.isNotBlank((CharSequence)msg)) continue;
            sb.append(msg);
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String execute0(String modelId, ActionParameter p) {
        int count;
        try {
            count = ((RecalcService)p.appctx.getBean(StoreModelUtils.recalcServiceName(modelId), RecalcService.class)).recalc(p);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.warn((Object)e, (Throwable)e);
            count = 0;
        }
        return count + " data is processed in " + modelId;
    }
}

