/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DbProcessBean;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.core.util.FileUtils;
import jp.jasminesoft.jfc.job.JFCBaseJobBean;
import jp.jasminesoft.jfc.job.JfcjobstatusRegistryService;
import jp.jasminesoft.jfc.model.jfcjobstatus.IJfcjobstatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionException;

public class DownloadJob
extends JFCBaseJobBean {
    private static final Logger logger = LogManager.getLogger((String)DownloadJob.class.getName());
    private String pbeanid;
    private static final String OutputfilenameType_Temp = "temp";
    private static final String OutputfilenameType_Filename = "filename";
    private static final String OutputfilenameType_Ext = "ext";

    public String getProcessBeanId() {
        return this.pbeanid;
    }

    public void setProcessBeanId(String pbeanid) {
        this.pbeanid = pbeanid;
    }

    @Override
    protected String executeInternal0(Map<String, Object> jobparamMap, Map<String, Object> dataMap, Map<String, Object> ctxMap, ActionParameter p) throws JobExecutionException {
        DbProcessBean pbean = (DbProcessBean)p.appctx.getBean(this.getProcessBeanId());
        pbean.setActionParameter(p);
        Object ret = null;
        try {
            String outputfilename = (String)dataMap.get("outputfilename");
            String outputdir = (String)dataMap.get("outputdir");
            String outputfilenametype = (String)dataMap.get("outputfilenametype");
            outputfilenametype = DownloadJob.getOutputfilenametype(outputfilename, outputfilenametype);
            File file = DownloadJob.getOutputfile(outputfilename, outputdir);
            logger.info(JFCUtils.logmsg(p, "start. outputfilename=" + file));
            pbean.setParameter("output_local", true);
            pbean.setParameter("outputfilename", file);
            pbean.setParameter("csv_encoding", dataMap.get("csv_encoding"));
            pbean.setParameter("getallmodelitem", dataMap.get("getallmodelitem"));
            pbean.setParameter("outputmode", dataMap.get("outputmode"));
            pbean.setParameter("fileext", dataMap.get("fileext"));
            pbean.setParameter("condition", dataMap.get("condition"));
            pbean.setParameter("targetitems", this.createStringCollection(dataMap.get("targetitems")));
            pbean.setParameter("sort_key", this.createStringArray(dataMap.get("sort_key")));
            p.request.setAttribute("isDeniedNullForward", (Object)Boolean.FALSE);
            p.request.setAttribute("DownloadJob.output_local", (Object)Boolean.TRUE);
            ret = pbean.run();
            if (ret != null && ret instanceof String) {
                if (file.length() == 0L) {
                    file.delete();
                }
                return (String)ret;
            }
            file = DownloadJob.renameDownloadedLocalFile(p, file, outputfilenametype);
            IJfcjobstatus jobstatus = (IJfcjobstatus)p.request.getAttribute(IJfcjobstatus.class.getName());
            if (jobstatus != null) {
                JfcjobstatusRegistryService service = (JfcjobstatusRegistryService)p.appctx.getBean(JfcjobstatusRegistryService.class);
                String outputfilename1 = service.getInfo(jobstatus, "outputfilename");
                if (outputfilename1 == null) {
                    outputfilename1 = file.getName();
                }
                service.addInfoFilename(jobstatus, "outputfilename", outputfilename1, file);
            }
            logger.info(JFCUtils.logmsg(p, "finished. outputfilename=" + file));
        }
        catch (Exception e) {
            logger.warn(JFCUtils.logmsg(p, e.getMessage()), (Throwable)e);
        }
        return ret == null ? null : ret.toString();
    }

    private String[] createStringArray(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof String) {
            String[] sa = ((String)object).split(",");
            return sa;
        }
        logger.error("sort_key is unknown type " + object.getClass() + ". value:" + object.toString());
        return null;
    }

    private Collection<String> createStringCollection(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            Collection list = (Collection)object;
            return list;
        }
        if (object instanceof String) {
            String[] sa = ((String)object).split(",");
            return Arrays.asList(sa);
        }
        logger.error("targetitems is unknown type " + object.getClass() + ". value:" + object.toString());
        return null;
    }

    public static String getOutputfilenametype(String outputfilename, String outputfilenametype) {
        if (outputfilenametype == null) {
            outputfilenametype = OutputfilenameType_Temp;
        }
        if (outputfilename != null) {
            outputfilenametype = OutputfilenameType_Temp;
        }
        if (outputfilenametype.equals(OutputfilenameType_Temp) || outputfilenametype.equals(OutputfilenameType_Filename) || outputfilenametype.equals(OutputfilenameType_Ext)) {
            return outputfilenametype;
        }
        return OutputfilenameType_Temp;
    }

    public static File getOutputfile(String outputfilename, String outputdir) throws IOException {
        File file;
        if (outputfilename != null) {
            file = new File(outputfilename);
        } else if (outputdir != null) {
            File odir;
            try {
                odir = JFCUtils.createFile(outputdir);
                if (odir == null) {
                    odir = new File(outputdir);
                }
                if (!odir.exists() && !odir.mkdirs()) {
                    logger.warn("Failed create outputdir, use default temporary dir. " + outputdir);
                    odir = null;
                }
            }
            catch (IllegalStateException e) {
                logger.warn("Illegal outputdir parameter, use default temporary dir. " + outputdir);
                odir = null;
            }
            logger.debug("odir=" + odir);
            file = File.createTempFile("download_", ".csv", odir);
        } else {
            file = File.createTempFile("download_", ".csv");
        }
        return file;
    }

    public static File renameDownloadedLocalFile(ActionParameter p, File file, String outputfilenametype) {
        File newfile;
        if (outputfilenametype.equals(OutputfilenameType_Temp)) {
            return file;
        }
        String outfilename = (String)p.request.getAttribute("outfilename");
        if (outfilename == null) {
            logger.error("outputfile is null. use temp file " + file);
            return file;
        }
        if (outputfilenametype.equals(OutputfilenameType_Filename)) {
            newfile = new File(file.getParentFile(), outfilename);
        } else {
            String origfn = file.getName();
            int cnt = origfn.lastIndexOf(46);
            String woextfn = origfn;
            if (cnt > 0) {
                woextfn = origfn.substring(0, cnt);
            }
            String ext = "";
            int cnt2 = outfilename.lastIndexOf(46);
            if (cnt2 > 0) {
                ext = outfilename.substring(cnt2);
            }
            newfile = new File(file.getParentFile(), woextfn + ext);
        }
        try {
            FileUtils.moveFile((File)file, (File)newfile);
            file = newfile;
        }
        catch (IOException e) {
            logger.debug("occur Exception", (Throwable)e);
            logger.error("Failed rename to " + file + " to " + newfile);
        }
        return file;
    }
}

