/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.security.Permission;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.job.ExportTask;
import jp.jasminesoft.jfc.job.JFCBaseJobBean;
import jp.jasminesoft.jfc.job.TaskException;
import org.quartz.JobExecutionException;

public class ExportJob
extends JFCBaseJobBean {
    @Override
    public Permission getPermission() {
        return new JFCAppPermission("admin", "all");
    }

    @Override
    protected boolean checkMaintenance(Map<String, Object> dataMap) {
        boolean ret = true;
        String is_maintenance_str = (String)dataMap.get("maintenance");
        if (is_maintenance_str != null && !Boolean.parseBoolean(is_maintenance_str)) {
            ret = false;
        }
        return ret;
    }

    @Override
    protected String executeInternal0(Map<String, Object> jobparamMap, Map<String, Object> dataMap, Map<String, Object> ctxMap, ActionParameter p) throws JobExecutionException {
        ExportTask task = new ExportTask();
        String target = (String)dataMap.get("target");
        task.setTarget(target);
        String exclude = (String)dataMap.get("exclude");
        task.setExclude(exclude);
        String unlinkFileCommand = (String)dataMap.get("unlinkfile");
        task.setUnlinkfile(unlinkFileCommand);
        Boolean useAsZip = Boolean.valueOf((String)dataMap.get("zip"));
        task.setUseAsZip(useAsZip);
        task.setDebug(this.isDebug());
        task.setLogHeader(this.getLogHeader());
        String ret = null;
        try {
            ret = task.execute(p);
        }
        catch (TaskException e) {
            throw new JobExecutionException(e.getMessage());
        }
        return ret;
    }
}

