/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.util.Set;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.job.InitializeSchedulerListener;
import jp.jasminesoft.jfc.job.Schedule;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;

public abstract class InitializeSchedulerListenerBase
implements InitializeSchedulerListener {
    private static final Logger logger = LogManager.getLogger(InitializeSchedulerListenerBase.class);

    protected abstract Class<? extends Job> getJobClass();

    protected abstract String getTriggername();

    protected abstract String getTriggergroup();

    protected abstract String getJobname();

    protected abstract String getJobgroup();

    protected abstract Schedule getJobSchedule();

    protected void unscheduleJob(Scheduler sched) {
        block3: {
            logger.debug("unscheduleJob");
            try {
                GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)this.getTriggergroup());
                Set triggerKeys = sched.getTriggerKeys(groupMatcher);
                for (TriggerKey triggerKey : triggerKeys) {
                    logger.debug("delete " + triggerKey.getName() + "::" + triggerKey.getGroup());
                    sched.unscheduleJob(triggerKey);
                }
            }
            catch (SchedulerException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00920), LogCodeManager.getMessage(LogCode.JFC00920, e.getMessage()));
                logger.debug((Object)e);
                if (!logger.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
    }

    protected void scheduleJob(Scheduler sched) {
        JobDetail job = JobBuilder.newJob(this.getJobClass()).withIdentity(this.getJobname(), this.getJobgroup()).build();
        Schedule sch = this.getJobSchedule();
        Trigger trigger = null;
        trigger = TriggerBuilder.newTrigger().withIdentity(this.getTriggername(), this.getTriggergroup()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)sch.toString())).forJob(this.getJobname(), this.getJobgroup()).build();
        try {
            if (trigger != null) {
                sched.scheduleJob(job, trigger);
                logger.info("(admin@localhost) " + this.getJobname() + " is successfully registerd, " + sch.toString());
            }
        }
        catch (SchedulerException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00922), LogCodeManager.getMessage(LogCode.JFC00922, e.getMessage()));
        }
    }
}

