/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.job.JfcjobstatusRegistryService;
import jp.jasminesoft.jfc.model.jfcjobstatus.IJfcjobstatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class JfcjobstatusRegistryServiceAmqpImpl
extends JfcjobstatusRegistryService {
    private static final Logger logger = LogManager.getLogger((String)JfcjobstatusRegistryServiceAmqpImpl.class.getName());
    @Autowired
    @Qualifier(value="rabbitTemplate")
    private RabbitTemplate amqpTemplate;
    private String defaultRoutingKey;

    public String getDefaultRoutingKey() {
        return this.defaultRoutingKey;
    }

    public void setDefaultRoutingKey(String defaultRoutingKey) {
        logger.debug("set " + defaultRoutingKey);
        this.defaultRoutingKey = defaultRoutingKey;
    }

    @Override
    public void sendJobMessage(String exchange, String routingKey, String jobname, Map<String, Object> jobparamMap, ActionParameter p) {
        logger.debug("start");
        if (!this.isEnableSendMessage(exchange, routingKey, jobname, jobparamMap, p)) {
            return;
        }
        String username = p.user.getUsername();
        boolean ignoreSaveJfcjobstatus = this.getIgnoreSaveJfcjobstatus();
        IJfcjobstatus jobstatus = null;
        if (!ignoreSaveJfcjobstatus) {
            logger.debug("save jobstatus");
            EntityHelper jfcjobstatusEntityHelper = (EntityHelper)p.appctx.getBean("JfcjobstatusHelper", EntityHelper.class);
            jobstatus = (IJfcjobstatus)((Object)jfcjobstatusEntityHelper.initialize(p));
            jobstatus.setJobname(jobname);
            jobstatus.setUsername(username);
            jobstatus.setExectype(IJfcjobstatus.Exectype.Queue.toString());
            jobstatus.setStatustype(IJfcjobstatus.Statustype.NotExecute.toString());
            this.insertJfcjobstatus(p, jobstatus);
            jobparamMap.put(IJfcjobstatus.class.getName() + "_id", jobstatus.getId());
        }
        Map<String, Object> paramMap = this.createParamMap(jobname, jobparamMap, p, username);
        try {
            String templateRoutingKey;
            if (logger.isDebugEnabled()) {
                logger.debug("template exchange = " + this.amqpTemplate.getExchange());
                logger.debug("template routing key = " + this.amqpTemplate.getRoutingKey());
                logger.debug("paramMap = " + paramMap);
            }
            if (StringUtils.isBlank((CharSequence)(templateRoutingKey = this.amqpTemplate.getRoutingKey())) && routingKey == null) {
                routingKey = this.defaultRoutingKey;
                logger.debug("use defaultRoutingKey " + this.defaultRoutingKey);
            }
            logger.info("send jobmessage. routingKey=" + routingKey + ", jobname=" + jobname + ", username=" + username);
            if (exchange != null) {
                logger.info("exchange = " + exchange);
            }
            if (exchange != null) {
                this.amqpTemplate.convertAndSend(exchange, routingKey, paramMap);
            } else if (routingKey != null) {
                this.amqpTemplate.convertAndSend(routingKey, paramMap);
            } else {
                this.amqpTemplate.convertAndSend(paramMap);
            }
            logger.debug("success");
        }
        catch (Exception e) {
            logger.debug("failed, occur Exception", (Throwable)e);
            if (jobstatus != null) {
                this.deleteJfcjobstatus(p, jobstatus);
            }
            throw e;
        }
    }
}

