/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.job.JfcjobstatusRegistryService;
import jp.jasminesoft.jfc.model.jfcjobstatus.IJfcjobstatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jms.core.JmsTemplate;

public class JfcjobstatusRegistryServiceJmsImpl
extends JfcjobstatusRegistryService {
    private static final Logger logger = LogManager.getLogger((String)JfcjobstatusRegistryServiceJmsImpl.class.getName());
    private JmsTemplate jmsTemplate;
    private String defaultDestinationName;

    public JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public String getDefaultDestinationName() {
        return this.defaultDestinationName;
    }

    public void setDefaultDestinationName(String defaultDestinationName) {
        logger.debug("set " + defaultDestinationName);
        this.defaultDestinationName = defaultDestinationName;
    }

    @Override
    public void sendJobMessage(String exchange, String destinationName, String jobname, Map<String, Object> jobparamMap, ActionParameter p) {
        logger.debug("start");
        if (!this.isEnableSendMessage(exchange, destinationName, jobname, jobparamMap, p)) {
            return;
        }
        String username = p.user.getUsername();
        boolean ignoreSaveJfcjobstatus = this.getIgnoreSaveJfcjobstatus();
        IJfcjobstatus jobstatus = null;
        if (!ignoreSaveJfcjobstatus) {
            logger.debug("save jobstatus");
            EntityHelper jfcjobstatusEntityHelper = (EntityHelper)p.appctx.getBean("JfcjobstatusHelper", EntityHelper.class);
            jobstatus = (IJfcjobstatus)((Object)jfcjobstatusEntityHelper.initialize(p));
            jobstatus.setJobname(jobname);
            jobstatus.setUsername(username);
            jobstatus.setExectype(IJfcjobstatus.Exectype.Queue.toString());
            jobstatus.setStatustype(IJfcjobstatus.Statustype.NotExecute.toString());
            this.insertJfcjobstatus(p, jobstatus);
            jobparamMap.put(IJfcjobstatus.class.getName() + "_id", jobstatus.getId());
        }
        Map<String, Object> paramMap = this.createParamMap(jobname, jobparamMap, p, username);
        try {
            String templateDestinationName;
            if (logger.isDebugEnabled()) {
                logger.debug("template default destinationName = " + this.jmsTemplate.getDefaultDestinationName());
                logger.debug("paramMap = " + paramMap);
            }
            if (StringUtils.isBlank((CharSequence)(templateDestinationName = this.jmsTemplate.getDefaultDestinationName())) && destinationName == null) {
                destinationName = this.defaultDestinationName;
                logger.debug("use defaultDestinationName " + this.defaultDestinationName);
            }
            logger.info("send jobmessage. destinationName=" + destinationName + ", jobname=" + jobname + ", username=" + username);
            if (destinationName != null) {
                this.jmsTemplate.convertAndSend(destinationName, paramMap);
            } else {
                this.jmsTemplate.convertAndSend(paramMap);
            }
            logger.debug("success");
        }
        catch (Exception e) {
            logger.debug("failed, occur Exception", (Throwable)e);
            if (jobstatus != null) {
                this.deleteJfcjobstatus(p, jobstatus);
            }
            throw e;
        }
    }
}

