/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.File;
import javax.servlet.ServletContext;
import jp.jasminesoft.jfc.KickLicenseUpdator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class LicenseUpdatorJob
extends QuartzJobBean {
    private static final Logger logger = LogManager.getLogger(LicenseUpdatorJob.class);

    protected void executeInternal(JobExecutionContext ctx) throws JobExecutionException {
        ApplicationContext appctx;
        try {
            appctx = (ApplicationContext)ctx.getScheduler().getContext().get((Object)"__jfcjob_appctx");
        }
        catch (SchedulerException e) {
            logger.error("Failed get applicationContext", (Throwable)e);
            return;
        }
        if (appctx == null) {
            logger.error("applicationContext is null, check set __jfcjob_appctx in scheduler bean applicationContextSchedulerContextKey property.");
            return;
        }
        ServletContext servletContext = (ServletContext)appctx.getBean(ServletContext.class);
        if (servletContext == null) {
            logger.error("ServletContext is null.");
            return;
        }
        Boolean isTestUse = (Boolean)servletContext.getAttribute("__jfc_licenseinfo_test_use");
        if (isTestUse != null && isTestUse.booleanValue() || servletContext.getAttribute("__jfc_licenseinfo_use_limit_date") == null) {
            ctx.put((Object)"jobComplete", (Object)Boolean.TRUE);
            return;
        }
        final File webInfFile = new File(servletContext.getRealPath("/"));
        KickLicenseUpdator kick = new KickLicenseUpdator(new KickLicenseUpdator.PathProvider(){

            @Override
            public String getPath(String org) {
                return new File(webInfFile, org).getAbsolutePath();
            }
        });
        String result = kick.kickUpdateProcess(null, null);
        if (result == null) {
            logger.info("(admin@localhost) suceeded updating license file");
            ctx.put((Object)"jobComplete", (Object)Boolean.TRUE);
        } else {
            logger.error("(admin@localhost) Failed to update license key file." + result);
            ctx.put((Object)"jobComplete", (Object)Boolean.FALSE);
        }
    }
}

