/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.menu;

import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.menu.CreateMyMenu;
import jp.jasminesoft.jfc.menu.Menubar;
import jp.jasminesoft.jfc.menu.URVisitor;
import jp.jasminesoft.util.JaxbUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JFCAppMenu {
    public static final String Logout = "logout";
    public static final String MENUBAR_CACHEKEY_HEADER = "__user.menubar.cache.key_";
    private static Map<URL, JFCAppMenu> menuMap;
    private Menubar menubar;
    private final URL url;
    private static final Logger logger;

    private JFCAppMenu(URL url) {
        this.url = url;
        this.init();
    }

    private void init() {
        logger.info("(admin@localhost) * load appmenu file " + this.url.toString());
        try {
            this.menubar = (Menubar)JaxbUtil.unmarshal((URL)this.url, Menubar.class);
        }
        catch (Exception e) {
            logger.debug("appmenu file " + this.url.toString() + " read error.", (Throwable)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        finally {
            if (this.menubar == null) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00080), LogCodeManager.getMessage(LogCode.JFC00080, new String[0]));
                this.menubar = new Menubar();
            }
        }
    }

    public static synchronized JFCAppMenu getInstance(URL url) {
        JFCAppMenu menu = menuMap.get(url);
        if (menu == null) {
            if (url == null) {
                return null;
            }
            menu = new JFCAppMenu(url);
            menuMap.put(url, menu);
        }
        return menu;
    }

    public Menubar getMenubar() {
        return this.menubar;
    }

    public Menubar getMenubar(User user) {
        return this.getMenubar(user, null, null, null);
    }

    public Menubar getMenubar(User user, String encode) {
        return this.getMenubar(user, encode, null, null);
    }

    public Menubar getMenubar(User user, String encode, String locale) {
        return this.getMenubar(user, encode, locale, null);
    }

    public Menubar getMenubar(User user, String encode, String locale, Map paramMap) {
        Menubar umenubar;
        long t1;
        block7: {
            if (user == null) {
                return this.getMenubar();
            }
            t1 = 0L;
            if (logger.isDebugEnabled()) {
                Date d1 = new Date();
                t1 = d1.getTime();
                if (user != null) {
                    logger.debug("user:" + user + ", hashcode:" + user.hashCode());
                }
            }
            if ((umenubar = this.getCache(user)) == null && user != null) {
                try {
                    logger.debug("Creating new menubar for user " + user.getUsername() + "...");
                    CreateMyMenu visitor = new CreateMyMenu(user, encode, locale, paramMap);
                    URVisitor.traverse(this.menubar, visitor);
                    umenubar = visitor.getMenubar();
                    this.putCache(user, umenubar);
                }
                catch (Exception e) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00081), LogCodeManager.getMessage(LogCode.JFC00081, new String[0]));
                    logger.debug((Object)e);
                    if (!logger.isDebugEnabled()) break block7;
                    e.printStackTrace();
                }
            }
        }
        if (logger.isDebugEnabled()) {
            Date d2 = new Date();
            long t2 = d2.getTime();
            logger.debug("Ellapsed Time : " + (t2 - t1) / 1000L + " sec.");
        }
        return umenubar;
    }

    private String cacheKey() {
        return MENUBAR_CACHEKEY_HEADER + this.url.toString();
    }

    private Menubar getCache(User user) {
        try {
            return (Menubar)user.getSession().getAttribute(this.cacheKey());
        }
        catch (IllegalStateException e) {
            logger.debug("This method was called on an already invalidated session");
            return null;
        }
    }

    private void putCache(User user, Menubar userMenubar) {
        try {
            user.getSession().setAttribute(this.cacheKey(), (Object)userMenubar);
        }
        catch (IllegalStateException e) {
            logger.debug("This method was called on an already invalidated session");
        }
    }

    public void clearUserMenubar(User user) {
        try {
            user.getSession().removeAttribute(this.cacheKey());
        }
        catch (IllegalStateException e) {
            logger.debug("This method was called on an already invalidated session");
        }
    }

    public static void main(String[] args) throws Exception {
        JFCAppMenu appmenu = JFCAppMenu.getInstance(new File(args[0]).toURL());
        Menubar menubar = appmenu.getMenubar(null, System.getProperty("file.encoding"));
        System.out.println(menubar);
    }

    static {
        logger = LogManager.getLogger((String)JFCAppMenu.class.getName());
        menuMap = new HashMap<URL, JFCAppMenu>();
    }
}

