/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.meta;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.jasminesoft.jfc.meta.ForeignkeyMeta;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EntityMeta<E extends ContainerBase<E>>
implements Serializable {
    private static final Logger logger = LogManager.getLogger((String)EntityMeta.class.getName());
    protected final String table;
    protected final Class<E> entityClass;
    protected Map<String, PropertyMetaBase<?>> propertyMetaMap;
    protected Map<String, PropertyMetaBase<?>> propertyMetaEntityNameMap;

    public EntityMeta(Class<E> entityClass, String table) {
        this.entityClass = entityClass;
        this.table = table;
    }

    private void initPropertyMetaMap() {
        Field[] fields;
        if (this.propertyMetaMap != null && this.propertyMetaEntityNameMap != null) {
            return;
        }
        LinkedHashMap<String, PropertyMetaBase> propertyMetaMap1 = new LinkedHashMap<String, PropertyMetaBase>();
        LinkedHashMap<String, PropertyMetaBase> propertyMetaEntityNameMap\uff11 = new LinkedHashMap<String, PropertyMetaBase>();
        for (Field field : fields = this.getClass().getFields()) {
            try {
                Object obj;
                if (logger.isDebugEnabled()) {
                    logger.debug("field.getName() " + field.getName());
                }
                if ((obj = field.get(this)) == null) {
                    logger.debug("obj is null");
                    continue;
                }
                if (!(obj instanceof PropertyMetaBase)) {
                    logger.debug("obj.getClass() " + obj.getClass());
                    continue;
                }
                PropertyMetaBase pmeta = (PropertyMetaBase)obj;
                propertyMetaMap1.put(field.getName(), pmeta);
                if (logger.isDebugEnabled()) {
                    logger.debug("pmeta.name() " + pmeta.name());
                }
                propertyMetaEntityNameMap\uff11.put(pmeta.name(), pmeta);
            }
            catch (IllegalArgumentException e) {
                logger.debug("IllegalArgumentException", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.debug("IllegalAccessException", (Throwable)e);
            }
        }
        this.propertyMetaMap = new LinkedHashMap(propertyMetaMap1);
        this.propertyMetaEntityNameMap = new LinkedHashMap(propertyMetaEntityNameMap\uff11);
    }

    public String table() {
        return this.table;
    }

    public Class<E> entityClass() {
        return this.entityClass;
    }

    public abstract PropertyMeta<?>[] primarykeyMeta();

    public ForeignkeyMeta<?>[] foreignkeyMeta() {
        return new ForeignkeyMeta[0];
    }

    public PropertyMeta<Long> versionMeta() {
        return null;
    }

    public PropertyMetaBase<?> propertyMeta(String itemName) {
        this.initPropertyMetaMap();
        PropertyMetaBase<?> pmeta = this.propertyMetaMap.get(itemName);
        if (pmeta == null) {
            throw new IllegalArgumentException("NoSuchField");
        }
        return pmeta;
    }

    public PropertyMetaBase<?> propertyMetaEntityName(String name) {
        this.initPropertyMetaMap();
        PropertyMetaBase<?> pmeta = this.propertyMetaEntityNameMap.get(name);
        if (pmeta == null) {
            throw new IllegalArgumentException("NoSuchField");
        }
        return pmeta;
    }
}

