/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.meta;

import java.io.Serializable;
import java.lang.reflect.Field;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.meta.EntityMeta;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PropertyMetaBase<P>
implements Serializable {
    private static final Logger logger = LogManager.getLogger(PropertyMetaBase.class);
    protected final EntityMeta<?> entityMeta;
    protected final String name;
    protected final String filterName;
    protected final boolean isTransient;

    public PropertyMetaBase(EntityMeta<?> entityMeta, String name, String filterName) {
        this(entityMeta, name, filterName, false);
    }

    public PropertyMetaBase(EntityMeta<?> entityMeta, String name, String filterName, boolean isTransient) {
        this.entityMeta = entityMeta;
        this.name = name;
        this.filterName = filterName;
        this.isTransient = isTransient;
    }

    public EntityMeta<?> entityMeta() {
        return this.entityMeta;
    }

    public String name() {
        return this.name;
    }

    public Class<P> getTypeClass() {
        return ClassUtils.getTypeClass(this);
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public String itemName() {
        for (Field field : this.entityMeta().getClass().getFields()) {
            try {
                Object object = field.get(this.entityMeta());
                if (!(object instanceof PropertyMetaBase)) continue;
                PropertyMetaBase metabase = (PropertyMetaBase)object;
                if (!this.name().equals(metabase.name())) continue;
                return field.getName();
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        throw new IllegalStateException("Item name not found.");
    }

    public String filterName() {
        return this.filterName;
    }
}

