/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.migratedb;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.sql.DataSource;
import jp.jasminesoft.jfc.migratedb.AbortException;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.internal.jdbc.DriverDataSource;

public class DBInfo {
    public DataSource dataSource;
    private String dbType;
    private String databaseDetailType;
    private Integer domainId = null;

    public DBInfo(DataSource dataSource, String dbType) {
        this.dataSource = dataSource;
        this.dbType = this.normalizeDbType(dbType);
        this.databaseDetailType = dbType;
    }

    public static DBInfo load() {
        DBInfo info;
        try (FileInputStream fs = new FileInputStream("./migrate_db.properties");){
            Properties props = new Properties();
            props.load(fs);
            info = new DBInfo((DataSource)new DriverDataSource(Thread.currentThread().getContextClassLoader(), null, props.getProperty("db.url"), props.getProperty("db.user"), props.getProperty("db.password")), DBInfo.getDbType(props.getProperty("db.url")));
        }
        catch (IOException ex) {
            throw new AbortException("Error: cannot read properties file.", ex);
        }
        return info;
    }

    public static String getDbType(String dbUrl) {
        if (dbUrl.startsWith("jdbc:mysql")) {
            return "MySQL";
        }
        if (dbUrl.startsWith("jdbc:postgresql")) {
            return "PostgreSQL";
        }
        if (dbUrl.startsWith("jdbc:oracle:")) {
            return "Oracle";
        }
        if (dbUrl.startsWith("jdbc:sqlserver:")) {
            return "SQLServer";
        }
        throw new AbortException("Error: unsupported database " + dbUrl);
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getDatabaseDetailType() {
        return this.databaseDetailType;
    }

    private String normalizeDbType(String dbType) {
        if (dbType.startsWith("mysql")) {
            return "MySQL";
        }
        if (dbType.startsWith("postgresql")) {
            return "PostgreSQL";
        }
        if (dbType.startsWith("oracle")) {
            return "Oracle";
        }
        if (dbType.startsWith("sqlserver")) {
            return "SQLServer";
        }
        throw new AbortException("Error: unsupported database " + dbType);
    }

    public String table() {
        if (this.domainId == null) {
            return Flyway.configure().getTable();
        }
        return Flyway.configure().getTable().concat("_domain" + this.domainId);
    }

    public void setDomainId(int domainId) {
        this.domainId = domainId;
    }
}

