/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.migratedb.command;

import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import jp.jasminesoft.jfc.core.util.FileUtils;
import jp.jasminesoft.jfc.migratedb.AbortException;
import jp.jasminesoft.jfc.migratedb.DBInfo;
import jp.jasminesoft.jfc.migratedb.Version;
import jp.jasminesoft.jfc.migratedb.command.Command;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CleanCommand
implements Command {
    private static final Logger logger = LogManager.getLogger((String)CleanCommand.class.getName());

    @Override
    public Version execute(DBInfo dbInfo, Path migratedbDir) {
        logger.info("start clean");
        FileUtils.deleteQuietly(migratedbDir.toFile());
        try (Connection con = dbInfo.dataSource().getConnection();
             Statement stmt = con.createStatement();){
            String histTable = dbInfo.table();
            String sql = "DROP TABLE " + histTable + " CASCADE";
            logger.info("execute SQL: " + sql);
            int ret = stmt.executeUpdate(sql);
            logger.info("result: " + ret);
            if (!con.getAutoCommit()) {
                con.commit();
            }
        }
        catch (SQLException ex) {
            throw new AbortException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u79fb\u884c\u306e\u5c65\u6b74\u30c6\u30fc\u30d6\u30eb\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
        logger.info("end clean");
        return null;
    }
}

