/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.migratedb.command;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.migratedb.AbortException;
import jp.jasminesoft.jfc.migratedb.DBInfo;
import jp.jasminesoft.jfc.migratedb.DDLHistFile;
import jp.jasminesoft.jfc.migratedb.Version;
import jp.jasminesoft.jfc.migratedb.command.Command;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;

public class MigrateCommand
implements Command {
    private static final Logger logger = LogManager.getLogger((String)MigrateCommand.class.getName());

    @Override
    public Version execute(DBInfo dbInfo, Path migratedbDir) {
        return this.execute(dbInfo, migratedbDir, null);
    }

    public Version execute(DBInfo dbInfo, Path migratedbDir, String allSQLContent) {
        logger.info("start migrate");
        Version version = new Version();
        logger.info("version: " + version);
        Path prevDDL = DDLHistFile.findLast(migratedbDir).getPath();
        logger.info("prevDDL: " + prevDDL);
        Path newDDL = DDLHistFile.create(version, migratedbDir, allSQLContent).getPath();
        logger.info("newDDL: " + newDDL);
        Path diffDir = migratedbDir.resolve("diff");
        DDLDiff ddldiff = dbInfo.getDatabaseDetailType().startsWith("mysql8") ? new DDLDiffMySQL8(diffDir, version, dbInfo, prevDDL, newDDL) : new DDLDiff(diffDir, version, dbInfo, prevDDL, newDDL);
        ddldiff.create();
        try {
            Flyway flyway = Flyway.configure().dataSource(dbInfo.dataSource()).table(dbInfo.table()).cleanDisabled(true).locations(new String[]{"filesystem:" + diffDir.toString()}).load();
            flyway.migrate();
        }
        catch (FlywayException ex) {
            throw new AbortException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u79fb\u884c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
        logger.info("end migrate");
        return version;
    }

    public static void main(String[] arg) throws IOException {
        boolean ischanged;
        logger.info("arg[0] " + arg[0]);
        logger.info("arg[1] " + arg[1]);
        DDLDiffMySQL8 ddldiff = new DDLDiffMySQL8(null, null, null, null, null);
        StringWriter writer = new StringWriter();
        if (arg[0].equals("1")) {
            Path origPrevDDL = Paths.get(arg[1], new String[0]);
            ischanged = ddldiff.replaceSQLFile(origPrevDDL, DDLDiffMySQL8.DefaultConstraintPattern1, writer);
        } else {
            Path diffFile = Paths.get(arg[1], new String[0]);
            ischanged = ddldiff.replaceSQLFile(diffFile, DDLDiffMySQL8.DefaultConstraintPattern2, writer);
        }
        System.out.println("ischanged " + ischanged);
        System.out.println("writer " + writer.toString());
    }

    public static class DDLDiffMySQL8
    extends DDLDiff {
        private static final Pattern TextColumnPattern = Pattern.compile(" text ([^,;]*)([,;]|$)", 2);
        private static final Pattern DefaultConstraintPattern1 = Pattern.compile("( |^) *default (\\('[^']*'\\))", 2);
        private static final Pattern DefaultConstraintPattern2 = Pattern.compile("( |^) *default ('[^']*')", 2);
        private static final Charset SQLFileCharset = StandardCharsets.UTF_8;
        private Path origPrevDDL;
        private Path origNewDDL;
        private Path origDiffFile;

        DDLDiffMySQL8(Path ddlDiffDir, Version version, DBInfo dbInfo, Path prevDDL, Path newDDL) {
            super(ddlDiffDir, version, dbInfo, prevDDL, newDDL);
            this.origPrevDDL = prevDDL;
            this.origNewDDL = newDDL;
        }

        @Override
        public void create() {
            try {
                super.create();
            }
            finally {
                if (logger.isDebugEnabled()) {
                    logger.debug("temporary prevDDL " + this.prevDDL);
                    logger.debug("temporary newDDL " + this.newDDL);
                    logger.debug("temporary diffFile " + this.diffFile);
                } else {
                    this.deleteWorkFiles();
                }
            }
        }

        private void deleteWorkFiles() {
            if (this.prevDDL != this.origPrevDDL) {
                try {
                    Files.delete(this.prevDDL);
                }
                catch (IOException e) {
                    logger.error("Failed delete temporary prev ddlfile " + this.prevDDL, (Throwable)e);
                }
            }
            if (this.newDDL != this.origNewDDL) {
                try {
                    Files.delete(this.newDDL);
                }
                catch (IOException e) {
                    logger.error("Failed delete temporary new ddlfile " + this.newDDL, (Throwable)e);
                }
            }
            if (this.diffFile != this.origDiffFile) {
                try {
                    Files.delete(this.diffFile);
                }
                catch (IOException e) {
                    logger.error("Failed delete temporary difffile " + this.diffFile, (Throwable)e);
                }
            }
        }

        @Override
        protected void before() throws IOException {
            this.prevDDL = this.replaceDDLFile(this.origPrevDDL);
            this.newDDL = this.replaceDDLFile(this.origNewDDL);
            this.origDiffFile = this.diffFile;
            if (this.prevDDL != this.origPrevDDL || this.newDDL != this.origNewDDL) {
                Path tempdifffile;
                String sqlext = ".sql";
                String tempfilename = this.diffFile.getFileName().toString();
                if (tempfilename.toLowerCase().endsWith(".sql")) {
                    tempfilename = tempfilename.substring(0, tempfilename.length() - ".sql".length());
                }
                this.diffFile = tempdifffile = Files.createTempFile(tempfilename, ".sql", new FileAttribute[0]);
            }
        }

        private Path replaceDDLFile(Path ddlfile) throws IOException {
            String content;
            try (StringWriter writer = new StringWriter();){
                boolean ischanged = this.replaceSQLFile(ddlfile, DefaultConstraintPattern1, writer);
                if (!ischanged) {
                    Path path = ddlfile;
                    return path;
                }
                content = writer.toString();
            }
            String sqlext = ".sql";
            String tempfilename = ddlfile.getFileName().toString();
            if (tempfilename.toLowerCase().endsWith(".sql")) {
                tempfilename = tempfilename.substring(0, tempfilename.length() - ".sql".length());
            }
            Path outputfilename = Files.createTempFile(tempfilename, ".sql", new FileAttribute[0]);
            Files.writeString(outputfilename, (CharSequence)content, SQLFileCharset, new OpenOption[0]);
            return outputfilename;
        }

        @Override
        protected void after() throws IOException {
            if (this.diffFile == this.origDiffFile) {
                return;
            }
            if (Files.notExists(this.diffFile, new LinkOption[0])) {
                return;
            }
            try (BufferedWriter writer = Files.newBufferedWriter(this.origDiffFile, SQLFileCharset, new OpenOption[0]);){
                this.replaceSQLFile(this.diffFile, DefaultConstraintPattern2, writer);
            }
        }

        private boolean replaceSQLFile(Path ddlfile, Pattern defaultConstraintPattern, Writer writer) throws IOException {
            boolean ischanged = false;
            try (BufferedReader reader = Files.newBufferedReader(ddlfile, SQLFileCharset);){
                String origline;
                while ((origline = reader.readLine()) != null) {
                    String line = this.replaceDDLColumnLine(origline, defaultConstraintPattern);
                    if (line != origline) {
                        ischanged = true;
                    }
                    writer.write(line);
                    writer.write(System.lineSeparator());
                }
            }
            return ischanged;
        }

        private String replaceDDLColumnLine(String line, Pattern defaultConstraintPattern) {
            Object defaultConstraint;
            Matcher defaultConstraintMatcher;
            Matcher textColumnMatcher = TextColumnPattern.matcher(line);
            if (!textColumnMatcher.find()) {
                return line;
            }
            int tstart = textColumnMatcher.start(1);
            int tend = textColumnMatcher.end(1);
            String origConstraint = textColumnMatcher.group(1);
            if (logger.isDebugEnabled()) {
                logger.debug("line " + line);
                logger.debug("origConstraint " + origConstraint);
            }
            if (!(defaultConstraintMatcher = defaultConstraintPattern.matcher(origConstraint)).find()) {
                return line;
            }
            int dstart = defaultConstraintMatcher.start(2);
            int dend = defaultConstraintMatcher.end(2);
            String origDefaultConstraint = defaultConstraintMatcher.group(2);
            if (logger.isDebugEnabled()) {
                logger.debug("origDefaultConstraint " + origDefaultConstraint);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(line.substring(0, tstart));
            sb.append(origConstraint.substring(0, dstart));
            if (defaultConstraintPattern == DefaultConstraintPattern1) {
                defaultConstraint = origDefaultConstraint.substring(1, origDefaultConstraint.length() - 1);
            } else if (defaultConstraintPattern == DefaultConstraintPattern2) {
                defaultConstraint = "(" + origDefaultConstraint + ")";
            } else {
                throw new IllegalStateException("Unknown DefaultConstraintPattern");
            }
            sb.append((String)defaultConstraint);
            sb.append(origConstraint.substring(dend));
            String footer = line.substring(tend);
            if (footer.length() > 0) {
                sb.append(this.replaceDDLColumnLine(footer, defaultConstraintPattern));
            }
            String newline = sb.toString();
            return newline;
        }
    }

    public static class DDLDiff {
        protected Path ddlDiffDir;
        protected Version version;
        protected DBInfo dbInfo;
        protected Path prevDDL;
        protected Path newDDL;
        protected Path diffFile;

        DDLDiff(Path ddlDiffDir, Version version, DBInfo dbInfo, Path prevDDL, Path newDDL) {
            this.ddlDiffDir = ddlDiffDir;
            this.version = version;
            this.dbInfo = dbInfo;
            this.prevDDL = prevDDL;
            this.newDDL = newDDL;
        }

        public void create() {
            this.diffFile = this.ddlDiffDir.resolve("V" + this.version + "__.sql");
            try {
                if (Files.notExists(this.ddlDiffDir, new LinkOption[0])) {
                    Files.createDirectory(this.ddlDiffDir, new FileAttribute[0]);
                }
            }
            catch (IOException ex) {
                throw new AbortException("Error: can't create directory " + this.ddlDiffDir);
            }
            String dbType = this.dbInfo.getDbType();
            try {
                this.before();
                ProcessBuilder pb = System.getProperty("os.name").toLowerCase().startsWith("windows") ? new ProcessBuilder("ddldiff.exe", dbType, this.prevDDL.toString(), this.newDDL.toString()) : new ProcessBuilder("./ddldiff", dbType, this.prevDDL.toString(), this.newDDL.toString());
                pb.redirectOutput(this.diffFile.toFile());
                Process process = pb.start();
                int result = process.waitFor();
                if (result != 0) {
                    throw new AbortException("Error: ddldiff terminated with an incorrect exit code " + result);
                }
                this.after();
            }
            catch (IOException | InterruptedException ex) {
                throw new AbortException("Error: ddldiff terminated abnormally", ex);
            }
        }

        protected void before() throws IOException {
        }

        protected void after() throws IOException {
        }
    }
}

