/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog;

import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.controller.LogoffController;
import jp.jasminesoft.jfc.controller.SetNewPasswordController;
import jp.jasminesoft.jfc.core.support.spring.security.MultipleSessionLoginUrlAuthenticationEntryPoint;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.service.LogonService;

public enum LogCodeCondition {
    LogonSuccess(LogCode.JFC00001){

        @Override
        public boolean match(Systemlog slog) {
            if (this.matchCaller(slog, LogonService.class, "logon")) {
                return this.matchMessage(slog);
            }
            return false;
        }
    }
    ,
    ConnectionRunout(LogCode.JFC00019){

        @Override
        public boolean match(Systemlog slog) {
            if (slog.getClassname().indexOf("jp.jasminesoft.jfc._check.LicenseCheck") >= 0) {
                return this.matchMessage(slog);
            }
            return false;
        }
    }
    ,
    SessionTimedout(LogCode.JFC00023){

        @Override
        public boolean match(Systemlog slog) {
            if (this.matchCaller(slog, LogoffController.class, "perform0") || this.matchCaller(slog, MultipleSessionLoginUrlAuthenticationEntryPoint.class, "addAutoLogoffMessage")) {
                return this.matchMessage(slog);
            }
            return false;
        }
    }
    ,
    AccountLocked(LogCode.JFC00015){

        @Override
        public boolean match(Systemlog slog) {
            if (this.matchCaller(slog, LogonService.class, "logon")) {
                return this.matchMessage(slog);
            }
            return false;
        }
    }
    ,
    OpsByReminders(LogCode.JFC00043){

        @Override
        public boolean match(Systemlog slog) {
            if (this.matchCaller(slog, SetNewPasswordController.class, "execute")) {
                return this.matchMessage(slog);
            }
            return false;
        }
    };

    private String msg;

    private LogCodeCondition(LogCode code) {
        this.msg = LogCodeManager.createCode(code);
    }

    public String getMessage() {
        return this.msg;
    }

    protected boolean matchCaller(Systemlog slog, Class<?> class1, String methodname) {
        return methodname.equals(slog.getMethodname()) && class1.getName().equals(slog.getClassname());
    }

    protected boolean matchMessage(Systemlog slog) {
        return slog.getMessage().indexOf(this.msg) >= 0;
    }

    public boolean match(Systemlog slog) {
        return this.matchMessage(slog);
    }
}

