/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog.analyzer;

import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.model.systemlog.LogCodeCondition;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.SystemlogManager;
import jp.jasminesoft.jfc.model.systemlog.analyzer.LogAnalyzerImpl;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogAnalyzerBaseImpl
extends LogAnalyzerImpl {
    private static final Logger logger = LogManager.getLogger((String)LogAnalyzerBaseImpl.class.getName());

    protected Stream<LogAnalyzeEntry> getLogAnalyzeEntry(Date from, Date to) {
        return this.getSystemlogManager().getLogEntry(from, to, this.getSystemlogKind()).map(e -> this.getLogAnalyzeEntry((SystemlogManager.LogEntry)e)).filter(lae -> lae != null);
    }

    protected LogAnalyzeEntry getLogAnalyzeEntry(SystemlogManager.LogEntry e) {
        try {
            LogAnalyzeEntry lae = new LogAnalyzeEntry(e);
            e.forEach(slog -> this.updateLogAnalyzeEntry(lae, (Systemlog)slog));
            return lae;
        }
        catch (IOException e1) {
            logger.error("failed read log file " + e.filename(), (Throwable)e1);
            return null;
        }
    }

    protected void updateLogAnalyzeEntry(LogAnalyzeEntry lae, Systemlog slog) {
        if (!slog.getType().equals("INFO")) {
            return;
        }
        LocalDate d = LogAnalyzerBaseImpl.date2LocalDate(slog.getDateTime());
        for (LogCodeCondition logcode : LogCodeCondition.values()) {
            int hour;
            if (!logcode.match(slog)) continue;
            Map<LocalDate, Integer> logonPerMonthMap = lae.getLogonPerMonth(logcode);
            Integer count = logonPerMonthMap.get(d);
            count = count != null ? Integer.valueOf(count + 1) : Integer.valueOf(1);
            logonPerMonthMap.put(d, count);
            int[] countByHour = lae.getCountByHour(logcode);
            int n = hour = this.getHour(slog.getDateTime());
            countByHour[n] = countByHour[n] + 1;
        }
    }

    @Override
    public int[] getCountByMonth(Date from_day, Date to_day, LogCodeCondition logCode) {
        HashMap logonPerMonthMap = new HashMap();
        this.getLogAnalyzeEntry(from_day, to_day).flatMap(lae -> lae.getLogonPerMonth(logCode).entrySet().stream()).forEach(e -> {
            Integer count = (Integer)logonPerMonthMap.get(e.getKey());
            count = count == null ? (Integer)e.getValue() : Integer.valueOf((Integer)e.getValue() + count);
            logonPerMonthMap.put((LocalDate)e.getKey(), count);
        });
        ArrayList<Integer> list = new ArrayList<Integer>();
        LocalDate d = LogAnalyzerBaseImpl.date2LocalDate(from_day);
        LocalDate to = LogAnalyzerBaseImpl.date2LocalDate(to_day).plusDays(1L);
        while (d.isBefore(to)) {
            if (!logonPerMonthMap.containsKey(d)) {
                list.add(0);
            } else {
                list.add((Integer)logonPerMonthMap.get(d));
            }
            d = d.plusDays(1L);
        }
        Integer[] ret = list.toArray(new Integer[list.size()]);
        return ArrayUtils.toPrimitive((Integer[])ret);
    }

    @Override
    public int[] getCountByDay(Date from_day, Date to_day, LogCodeCondition logCode) {
        int[] countByHour = new int[24];
        this.getLogAnalyzeEntry(from_day, to_day).forEach(lae -> this.mergeArray(lae.getCountByHour(logCode), countByHour));
        return countByHour;
    }

    private int[] mergeArray(int[] src, int[] base) {
        for (int i = 0; i < src.length; ++i) {
            int n = i;
            base[n] = base[n] + src[i];
        }
        return base;
    }

    private int getHour(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int hour = cal.get(11);
        return hour;
    }

    private static LocalDate date2LocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    protected static class LogAnalyzeEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Date targetDate;
        private String filename;
        private long length;
        private long lastModified;
        private Map<LogCodeCondition, Map<LocalDate, Integer>> logonPerMonthMaps = new HashMap<LogCodeCondition, Map<LocalDate, Integer>>();
        private Map<LogCodeCondition, int[]> countByHours = new HashMap<LogCodeCondition, int[]>();

        LogAnalyzeEntry(SystemlogManager.LogEntry e) {
            for (LogCodeCondition logcode : LogCodeCondition.values()) {
                this.logonPerMonthMaps.put(logcode, new TreeMap());
                this.countByHours.put(logcode, new int[24]);
            }
            this.targetDate = e.targetDate();
            this.filename = e.filename();
            this.length = e.length();
            this.lastModified = e.lastModified();
        }

        public boolean same(SystemlogManager.LogEntry e) {
            if (logger.isDebugEnabled()) {
                logger.debug("1 e " + e);
                logger.debug("1 this " + this);
            }
            return e.targetDate().equals(this.targetDate()) && e.length() == this.length() && e.filename().equals(this.filename()) && e.lastModified() == this.lastModified();
        }

        public Date targetDate() {
            return this.targetDate;
        }

        public String filename() {
            return this.filename;
        }

        public long length() {
            return this.length;
        }

        public long lastModified() {
            return this.lastModified;
        }

        public Map<LocalDate, Integer> getLogonPerMonth(LogCodeCondition logcode) {
            return this.logonPerMonthMaps.get((Object)logcode);
        }

        public int[] getCountByHour(LogCodeCondition logcode) {
            return this.countByHours.get((Object)logcode);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" targetDate=").append(this.targetDate());
            sb.append(" filename=").append(this.filename());
            sb.append(" length=").append(this.length());
            sb.append(" lastModified=").append(this.lastModified());
            return sb.toString();
        }
    }
}

