/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog.analyzer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.analyzer.LogCodeUserActionTypeMapper;
import jp.jasminesoft.jfc.model.systemlog.analyzer.UserActionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserAction {
    private static final Logger LOGGER = LogManager.getLogger((String)UserAction.class.getName());
    private static DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private LocalDateTime dateTime;
    private String dateTimeString = "";
    private String userName = "";
    private String targetModel = "";
    private String origMessage = "";
    private String logCode = "";
    private UserActionType actionType = UserActionType.UNKNOWN;
    private String actionValue = "";
    private static Set<String> METHODS_IGNORED = new HashSet<String>();
    private static Set<String> ACTIONS_IGNORED = new HashSet<String>();

    public UserAction(String userId, Systemlog log) {
        this.userName = !userId.equals(log.getUsername()) ? userId : log.getUsername();
        this.parseSystemlog(log);
    }

    @JsonIgnore
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @JsonProperty(value="dateTime")
    public String getDateTimeAsString() {
        return this.dateTimeString;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getLogCode() {
        return this.logCode;
    }

    public UserActionType getAction() {
        return this.actionType;
    }

    public String getActionJp() {
        return this.actionType.toStringJp();
    }

    public String getActionEn() {
        return this.actionType.toStringEn();
    }

    public String getActionValue() {
        return this.actionValue;
    }

    public void setActionValue(String actionValue) {
        this.actionValue = actionValue;
    }

    public String getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(String targetModel) {
        this.targetModel = targetModel;
    }

    @JsonIgnore
    public String getOriginalMessage() {
        return this.origMessage;
    }

    public String toString() {
        StringJoiner buf = new StringJoiner(", ");
        buf.add(this.dateTimeString);
        buf.add("User=" + this.userName);
        buf.add("Action=" + this.actionType.toString());
        buf.add("Model=" + this.targetModel);
        if (this.actionValue != null) {
            buf.add("Value=" + this.actionValue);
        }
        return buf.toString();
    }

    private void parseSystemlog(Systemlog log) {
        this.dateTime = log.getDateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        this.dateTimeString = DTF.format(this.dateTime);
        String string = this.origMessage = log.getMessage() != null ? log.getMessage() : "";
        if (this.origMessage.startsWith("JFC-") && this.origMessage.indexOf(":") != -1) {
            this.actionValue = this.origMessage.substring(this.origMessage.indexOf(":") + 1);
            this.logCode = this.origMessage.substring(0, this.origMessage.indexOf(":"));
            Optional<UserActionType> opt = LogCodeUserActionTypeMapper.find(this.logCode);
            if (opt.isPresent()) {
                this.actionType = opt.get();
            } else {
                LOGGER.warn("Unknown Message Code '" + this.logCode + "' appeared. Will be ignored: " + this.getOriginalMessage());
                this.actionType = UserActionType.UNKNOWN;
                this.actionValue = this.getOriginalMessage();
            }
        } else if (log.getMethodname() != null) {
            String method = log.getMethodname();
            if (METHODS_IGNORED.contains(method)) {
                this.actionType = UserActionType.IGNORE;
            } else if (method.equals("log") && log.getClassname() != null && log.getClassname().endsWith("CriteriaConverter")) {
                this.actionType = UserActionType.SEARCH_KEYWORD;
                String msg = log.getMessage().replace("[", "").replace("]", "");
                this.actionValue = msg = msg.substring(msg.indexOf("=") + 1);
                this.targetModel = this.modelNameFromCriteriaConv(log.getClassname());
            } else if (method.equals("get") && log.getClassname().equals("jp.jasminesoft.jfc.controller.DownloadFileController")) {
                this.actionType = UserActionType.FILE_DOWNLOAD;
                this.actionValue = log.getMessage();
            } else if (method.equals("send") && log.getClassname().equals("jp.jasminesoft.jfc.app.MailMessageManager")) {
                this.actionType = UserActionType.SEND_EMAIL;
                this.actionValue = log.getMessage();
            } else if (method.equalsIgnoreCase("perform_db") || method.equalsIgnoreCase("changelog")) {
                String msg = log.getMessage();
                String[] prts = msg.split("\\|");
                if (prts.length >= 2) {
                    String methodName = prts[0];
                    String actionName = prts[1].split(" ")[0];
                    if (ACTIONS_IGNORED.contains(actionName)) {
                        this.actionType = UserActionType.IGNORE;
                    } else if (actionName.equals("Search")) {
                        this.actionType = UserActionType.SHOWLIST_SEARCH;
                        this.targetModel = methodName.replace("showList", "");
                    } else if (actionName.startsWith("BeginInsert")) {
                        this.actionType = UserActionType.INSERT_BEGIN;
                        this.targetModel = methodName.replace("insert", "");
                    } else if (actionName.startsWith("DoInsert")) {
                        this.actionType = UserActionType.INSERT_DONE;
                        this.targetModel = methodName.replace("insert", "");
                    } else if (actionName.startsWith("BeginUpdate")) {
                        this.actionType = UserActionType.UPDATE_BEGIN;
                        this.targetModel = methodName.replace("update", "");
                        if (actionName.contains(":")) {
                            String objectId;
                            this.actionValue = objectId = actionName.split(":")[1];
                        }
                    } else if (actionName.startsWith("DoUpdate")) {
                        this.actionType = UserActionType.UPDATE_DONE;
                        this.targetModel = methodName.replace("update", "");
                    } else if (actionName.startsWith("DoDelete")) {
                        this.actionType = UserActionType.DELETE_DONE;
                        this.targetModel = methodName.replace("delete", "");
                        if (actionName.contains(":")) {
                            String objectId;
                            this.actionValue = objectId = actionName.split(":")[1];
                        }
                    } else if (actionName.startsWith("DoShow")) {
                        this.actionType = UserActionType.SHOW;
                        this.targetModel = methodName.replace("show", "");
                        if (actionName.contains(":")) {
                            String objectId;
                            this.actionValue = objectId = actionName.split(":")[1];
                        }
                    } else if (actionName.equals("AddItem")) {
                        this.actionType = UserActionType.ADD_ITEM;
                        this.targetModel = this.modelNameFromMethodName(methodName);
                    } else if (actionName.startsWith("FileUpload")) {
                        this.actionType = UserActionType.FILE_UPLOAD;
                        this.targetModel = this.modelNameFromMethodName(methodName);
                    } else if (actionName.equals("Cancel")) {
                        this.actionType = UserActionType.CANCEL;
                        this.targetModel = this.modelNameFromMethodName(methodName);
                    } else {
                        LOGGER.warn("Unknown ACTION: [" + actionName + "] = orig: " + log.toString());
                    }
                }
            } else {
                LOGGER.warn("Unknown METHOD: [" + method + "]  = orig: " + log.toString());
            }
        }
        if (this.actionType == null) {
            this.actionType = UserActionType.UNKNOWN;
            this.actionValue = log.getMessage();
        }
        if (this.targetModel.startsWith("my")) {
            this.targetModel = this.targetModel.replace("my", "");
        }
    }

    private String modelNameFromMethodName(String methodName) {
        String model = "";
        if (methodName.startsWith("searchList")) {
            model = methodName.replace("searchList", "");
        } else if (methodName.startsWith("insert")) {
            model = methodName.replace("insert", "");
        } else if (methodName.startsWith("update")) {
            model = methodName.replace("update", "");
        } else if (methodName.startsWith("delete")) {
            model = methodName.replace("delete", "");
        } else if (methodName.startsWith("search")) {
            model = methodName.replace("search", "");
        } else {
            LOGGER.error("Cannot clip model from method name [" + methodName + "] .");
        }
        return model;
    }

    private String modelNameFromCriteriaConv(String classname) {
        String model = "";
        if (classname.endsWith("CriteriaConverter")) {
            int startIdx = classname.lastIndexOf(".") + 1;
            int finishIdx = classname.lastIndexOf("CriteriaConverter");
            model = classname.substring(startIdx, finishIdx);
        }
        return model;
    }

    static {
        METHODS_IGNORED.add("addUserName");
        METHODS_IGNORED.add("removeUserName");
        METHODS_IGNORED.add("outputConditionToLog");
        ACTIONS_IGNORED.add("GetJson");
        ACTIONS_IGNORED.add("GetXml");
        ACTIONS_IGNORED.add("AsIs");
        ACTIONS_IGNORED.add("UserDefined");
    }
}

