/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog.filter;

import java.util.Arrays;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.filter.LogFilter;

public class AndOrLogFilter
extends LogFilter {
    private Type type_;
    private LogFilter[] filters_;

    public AndOrLogFilter(Type type, LogFilter ... filters) {
        if (type == null || filters == null || filters.length < 1) {
            throw new IllegalArgumentException("Input variables should not be empty.");
        }
        this.type_ = type;
        this.filters_ = filters;
    }

    @Override
    public boolean accept(Systemlog log) {
        if (this.type_ == Type.AND) {
            return Arrays.stream(this.filters_).allMatch(filter -> filter.accept(log));
        }
        return Arrays.stream(this.filters_).anyMatch(filter -> filter.accept(log));
    }

    public static enum Type {
        AND,
        OR;

    }
}

