/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.filter.LogFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassnameLogFilter
extends LogFilter {
    private static final Logger LOGGER = LogManager.getLogger((String)ClassnameLogFilter.class.getName());
    private Type type;
    private Set<String> classNameList;

    public ClassnameLogFilter(Type type, String ... classNames) {
        this.type = type;
        if (classNames == null || classNames.length < 1) {
            this.classNameList = new HashSet<String>();
        }
        this.classNameList = new HashSet<String>(Arrays.asList(classNames));
    }

    public void addClassname(String className) {
        if (className == null || className.trim().length() < 1) {
            return;
        }
        if (this.classNameList.contains(className)) {
            LOGGER.warn("Class name [" + className + "] is already set to be ignored.");
            return;
        }
        this.classNameList.add(className.trim());
    }

    @Override
    public boolean accept(Systemlog log) {
        if (this.type == Type.TO_INCLUDE) {
            return this.classNameList.contains(log.getClassname());
        }
        return !this.classNameList.contains(log.getClassname());
    }

    public static enum Type {
        TO_INCLUDE,
        TO_IGNORE;

    }
}

