/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.filter.LogFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PackagenameLogFilter
extends LogFilter {
    private static final Logger LOGGER = LogManager.getLogger((String)PackagenameLogFilter.class.getName());
    private Type type;
    private Set<String> packageNameList;

    public PackagenameLogFilter(Type type, String ... packageNames) {
        this.type = type;
        if (packageNames == null || packageNames.length < 1) {
            this.packageNameList = new HashSet<String>();
        }
        this.packageNameList = new HashSet<String>(Arrays.asList(packageNames));
    }

    public void addPackagename(String pkgName) {
        if (pkgName == null || pkgName.trim().length() < 1) {
            return;
        }
        if (this.packageNameList.contains(pkgName)) {
            LOGGER.warn("Pakcage name [" + pkgName + "] is already set to be ignored.");
            return;
        }
        this.packageNameList.add(pkgName.trim());
    }

    @Override
    public boolean accept(Systemlog log) {
        boolean contains = false;
        for (String pkg : this.packageNameList) {
            if (!log.getClassname().startsWith(pkg)) continue;
            contains = true;
            break;
        }
        if (this.type == Type.TO_INCLUDE) {
            return contains;
        }
        return !contains;
    }

    public static enum Type {
        TO_INCLUDE,
        TO_IGNORE;

    }
}

