/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog.util;

import jp.jasminesoft.jfc.model.systemlog.filter.AndOrLogFilter;
import jp.jasminesoft.jfc.model.systemlog.filter.ClassnameLogFilter;
import jp.jasminesoft.jfc.model.systemlog.filter.LogFilter;
import jp.jasminesoft.jfc.model.systemlog.filter.MessageLogFilter;
import jp.jasminesoft.jfc.model.systemlog.filter.NotLogFilter;
import jp.jasminesoft.jfc.model.systemlog.filter.UsernameLogFilter;
import jp.jasminesoft.jfc.model.systemlog.util.RegexUtil;

public class LogFilterPresets {
    private LogFilterPresets() {
    }

    public static LogFilter filterToPickupByUserId(String userId) {
        UsernameLogFilter usernameF = new UsernameLogFilter(userId, UsernameLogFilter.MatchType.Prefix);
        MessageLogFilter messageF = new MessageLogFilter(RegexUtil.contains(userId));
        messageF.addExcludeString("DoShow:" + userId);
        messageF.addExcludeString("BeginUpdate:" + userId);
        AndOrLogFilter OR = new AndOrLogFilter(AndOrLogFilter.Type.OR, usernameF, messageF);
        return OR;
    }

    public static LogFilter filterToRemoveSysMessage() {
        ClassnameLogFilter F_ignoredClasses = new ClassnameLogFilter(ClassnameLogFilter.Type.TO_IGNORE, "jp.jasminesoft.jfc.service.JfcConfig", "jp.jasminesoft.jfc.servlet.JFCQuartzInitializer", "jp.jasminesoft.jfc.textsearch.servlet.MakeTextIndexThread", "jp.jasminesoft.jfc.job.FileProcessTask", "jp.jasminesoft.jfc.JFCJobTriggerListener", "jp.jasminesoft.jfc.job.JFCBaseJobBean", "jp.jasminesoft.jfc.controller.AnalyticsLogController", "jp.jasminesoft.jfc.controller.AnalyticsLogAPIController");
        MessageLogFilter F_ignoreInitLoader = new MessageLogFilter(RegexUtil.notContain("initLoader"));
        NotLogFilter F_notAsterisk = new NotLogFilter(new MessageLogFilter("^(\\*).*$"));
        String regex = "^((?!JFC-(007|008|009|900)).)*$";
        MessageLogFilter F_ignoreJFCs = new MessageLogFilter(regex);
        AndOrLogFilter JOIN = new AndOrLogFilter(AndOrLogFilter.Type.AND, F_ignoredClasses, F_ignoreInitLoader, F_notAsterisk, F_ignoreJFCs);
        return JOIN;
    }
}

