/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.service.JFCAbstractEntityService;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JfcreporttemplateUtil {
    private static final Logger logger = LogManager.getLogger(JfcreporttemplateUtil.class);

    public static OutputType readTemplateValues(String templateid, Map<String, String> valueMap, ActionParameter p) {
        OutputType outputType;
        block40: {
            if (StringUtils.isEmpty((CharSequence)templateid)) {
                logger.warn("templateid is empty.");
                return OutputType.Download;
            }
            outputType = OutputType.Browser;
            JFCAbstractEntityService entityService = (JFCAbstractEntityService)p.appctx.getBean("JfcreporttemplateEntityService", JFCAbstractEntityService.class);
            File catalinahome_bin_dir = new File(System.getProperty("catalina.home"), "bin");
            String filename = null;
            String outputname = null;
            String outputfolder = null;
            String sheetname = null;
            String outputname4batch = null;
            try {
                Object obj = entityService.findById(templateid);
                if (obj == null && templateid.indexOf("_") > 0) {
                    templateid = templateid.substring(templateid.indexOf("_") + 1);
                    obj = entityService.findById(templateid);
                }
                if (obj != null) {
                    Object value;
                    if (valueMap != null) {
                        boolean hasTemplatefilename = false;
                        Object value2 = MethodUtils.invokeMethod(obj, (String)"getTemplatefileJshfilename", null);
                        if (value2 != null && value2 instanceof String && StringUtils.isNotEmpty((CharSequence)(filename = (String)value2))) {
                            File file;
                            if (File.separatorChar != '\\') {
                                filename = filename.replace('\\', '/');
                            }
                            if (!(file = new File(filename)).isAbsolute()) {
                                file = new File(catalinahome_bin_dir, filename);
                            }
                            filename = file.getAbsolutePath();
                            valueMap.put("templatefilename", filename);
                            hasTemplatefilename = true;
                        }
                        if ((value2 = MethodUtils.invokeMethod(obj, (String)"getTemplatefile", null)) != null && value2 instanceof String) {
                            String tfilename = (String)value2;
                            String suffix = null;
                            int ptr = tfilename.lastIndexOf(".");
                            if (ptr > 0) {
                                suffix = tfilename.substring(ptr + 1);
                                tfilename = tfilename.substring(0, ptr);
                            }
                            suffix = suffix != null ? suffix : "";
                            valueMap.put("templatefilename_original", tfilename);
                            valueMap.put("templatefilename_original_suffix", suffix);
                        }
                        if ((value2 = MethodUtils.invokeMethod(obj, (String)"getOutputfilename", null)) != null && value2 instanceof String && StringUtils.isNotEmpty((CharSequence)(outputname = (String)value2))) {
                            valueMap.put("outputfilename", outputname);
                        }
                        if ((value2 = MethodUtils.invokeMethod(obj, (String)"getSheetname", null)) != null && value2 instanceof String && StringUtils.isNotEmpty((CharSequence)(sheetname = (String)value2))) {
                            valueMap.put("sheetname", sheetname);
                        }
                        if ((value2 = MethodUtils.invokeMethod(obj, (String)"getOutputfilename4batch", null)) != null && value2 instanceof String && StringUtils.isNotEmpty((CharSequence)(outputname4batch = (String)value2))) {
                            valueMap.put("outputfilename4batch", outputname4batch);
                        }
                        if ((value2 = MethodUtils.invokeMethod(obj, (String)"getOutputfolder", null)) != null && value2 instanceof String && StringUtils.isNotEmpty((CharSequence)(outputfolder = (String)value2))) {
                            valueMap.put("outputfolder", outputfolder);
                        }
                        if ((value2 = MethodUtils.invokeMethod(obj, (String)"getContainer", null)) != null && value2.getClass().isArray()) {
                            Object[] array = (Object[])value2;
                            int size = Array.getLength(array);
                            int count = 0;
                            for (int i = 0; i < size; ++i) {
                                File file;
                                String cfilename;
                                Object element = Array.get(array, i);
                                Object evalue = MethodUtils.invokeMethod((Object)element, (String)"getCtemplatefileJshfilename", null);
                                if (evalue == null || !(evalue instanceof String) || !StringUtils.isNotEmpty((CharSequence)(cfilename = (String)evalue))) continue;
                                if (File.separatorChar != '\\') {
                                    cfilename = cfilename.replace('\\', '/');
                                }
                                if (!(file = new File(cfilename)).isAbsolute()) {
                                    file = new File(catalinahome_bin_dir, cfilename);
                                }
                                cfilename = file.getAbsolutePath();
                                Object evalue2 = MethodUtils.invokeMethod((Object)element, (String)"getCtemplatefile", null);
                                String tfilename = null;
                                String suffix = null;
                                if (evalue2 != null && evalue2 instanceof String) {
                                    tfilename = (String)evalue2;
                                    int ptr = tfilename.lastIndexOf(".");
                                    if (ptr > 0) {
                                        suffix = tfilename.substring(ptr + 1);
                                        tfilename = tfilename.substring(0, ptr);
                                    }
                                    String string = suffix = suffix != null ? suffix : "";
                                }
                                if (!hasTemplatefilename) {
                                    valueMap.put("templatefilename", cfilename);
                                    hasTemplatefilename = true;
                                    if (tfilename == null) continue;
                                    valueMap.put("templatefilename_original", tfilename);
                                    valueMap.put("templatefilename_original_suffix", suffix);
                                    continue;
                                }
                                valueMap.put("ctemplatefilename." + count, cfilename);
                                if (tfilename != null) {
                                    valueMap.put("ctemplatefilename_original" + count, tfilename);
                                    valueMap.put("ctemplatefilename_original_suffix." + count, suffix);
                                }
                                ++count;
                            }
                            valueMap.put("ctemplatefilelength", Integer.toString(count));
                        } else {
                            valueMap.put("ctemplatefilelength", "0");
                        }
                    }
                    if ((value = MethodUtils.invokeMethod(obj, (String)"getDispositiontype", null)) != null && value instanceof Integer) {
                        Integer dispositiontype = (Integer)value;
                        if (dispositiontype < 0) {
                            dispositiontype = 1;
                        }
                        switch (dispositiontype) {
                            case 1: {
                                outputType = OutputType.Browser;
                                if (valueMap != null) {
                                    valueMap.put("dispositiontype", OutputType.Browser.toString());
                                    break;
                                }
                                break block40;
                            }
                            case 2: {
                                outputType = OutputType.Download;
                                if (valueMap != null) {
                                    valueMap.put("dispositiontype", OutputType.Download.toString());
                                    break;
                                }
                                break block40;
                            }
                            case 3: {
                                outputType = OutputType.ServerFolderOverride;
                                if (valueMap != null) {
                                    valueMap.put("dispositiontype", OutputType.ServerFolderOverride.toString());
                                    break;
                                }
                                break block40;
                            }
                            case 4: {
                                outputType = OutputType.ServerFolderNoOverride;
                                if (valueMap != null) {
                                    valueMap.put("dispositiontype", OutputType.ServerFolderNoOverride.toString());
                                    break;
                                }
                                break block40;
                            }
                            default: {
                                if (valueMap != null) {
                                    valueMap.put("dispositiontype", OutputType.Browser.toString());
                                    break;
                                }
                                break block40;
                            }
                        }
                        break block40;
                    }
                    if (valueMap != null) {
                        valueMap.put("dispositiontype", OutputType.Browser.toString());
                    }
                    break block40;
                }
                logger.warn("No report template is found, " + templateid);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return outputType;
    }

    public static final String getPrintlayoutTemplateFileName(String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return "";
        }
        if ((filename = filename.trim()).startsWith("TEMPLATE(")) {
            String cnt = filename.substring("TEMPLATE(".length());
            if (cnt.endsWith(")")) {
                cnt = cnt.substring(0, cnt.length() - 1);
            }
            if ((cnt = cnt.trim()).startsWith("\"") && cnt.endsWith("\"")) {
                cnt = cnt.substring(1, cnt.length() - 1);
            } else if (cnt.startsWith("${") && cnt.endsWith("}")) {
                cnt = cnt.substring(2, cnt.length() - 1);
            }
            filename = cnt;
        }
        return filename;
    }

    public static final File createUniqueFile(File target) {
        Object n_path;
        if (!target.exists()) {
            return target;
        }
        do {
            String apath = target.getAbsolutePath();
            int ptr = apath.lastIndexOf(".");
            String suffix = apath.substring(ptr + 1);
            n_path = apath.substring(0, ptr);
            if ((ptr = ((String)n_path).lastIndexOf("_")) < 0) {
                n_path = (String)n_path + "_1." + suffix;
                continue;
            }
            String numpart = ((String)n_path).substring(ptr + 1);
            try {
                int num = Integer.parseInt(numpart);
                n_path = ((String)n_path).substring(0, ptr) + "_" + (num + 1) + "." + suffix;
            }
            catch (NumberFormatException e) {
                n_path = (String)n_path + "_1." + suffix;
            }
        } while ((target = new File((String)n_path)).exists());
        return target;
    }

    public static boolean isOutputType_Browser(String templateid, ActionParameter p) {
        return JfcreporttemplateUtil.isOutputType(templateid, p, OutputType.Browser);
    }

    public static boolean isOutputType_Download(String templateid, ActionParameter p) {
        return JfcreporttemplateUtil.isOutputType(templateid, p, OutputType.Download);
    }

    public static boolean isOutputType_SaveFolder(String templateid, ActionParameter p) {
        return JfcreporttemplateUtil.isOutputType(templateid, p, OutputType.ServerFolderOverride, OutputType.ServerFolderNoOverride);
    }

    private static boolean isOutputType(String templateid, ActionParameter p, OutputType ... candidates) {
        OutputType type = JfcreporttemplateUtil.readTemplateValues(templateid, null, p);
        for (OutputType candidate : candidates) {
            if (candidate != type) continue;
            return true;
        }
        return false;
    }

    public static enum OutputType {
        Browser,
        Download,
        ServerFolderOverride,
        ServerFolderNoOverride;

    }
}

