/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.poi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.repgen.ReportGeneratorException;
import jp.jasminesoft.jfc.repgen.ReportWorkbook;
import jp.jasminesoft.jfc.repgen.excel.poi.CellValueReplacer;
import jp.jasminesoft.jfc.repgen.excel.poi.POIReportGenerator;
import jp.jasminesoft.jfc.repgen.excel.poi.ReportWorkbookImpl;
import jp.jasminesoft.jfc.repgen.util.PlaceHolderValueNormalizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ReportGeneratorImpl
extends POIReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger((String)ReportGeneratorImpl.class.getName());

    @Override
    public void generate(ReportWorkbook rw, Map<String, Object> params, Map<String, String> typeparams, int sheetnum) throws IOException, ReportGeneratorException {
        if (!(rw instanceof ReportWorkbookImpl)) {
            LOGGER.log(LogCodeManager.getPriority(LogCode.JFC00244), LogCodeManager.getMessage(LogCode.JFC00244, rw.getClass().toString()));
            throw new IllegalArgumentException("Illegal ReportWorkbook class");
        }
        Workbook workbook = ((ReportWorkbookImpl)rw).getWorkbook();
        Sheet sheet = workbook.getSheetAt(sheetnum);
        LOGGER.debug("Report will be created as Excel 'detail' report.");
        this.replaceParamsOfSheet(sheet, params, typeparams, workbook);
        this.finish();
    }

    @Override
    public ReportWorkbook createReportWorkbook(File file, OutputStream out) throws IOException {
        if (file == null || out == null) {
            throw new IOException(LogCodeManager.getMessage(LogCode.JFC00243, new String[0]));
        }
        if (!file.exists()) {
            if (file.getName().equals("null")) {
                throw new IOException(LogCodeManager.getMessage(LogCode.JFC00251, new String[0]));
            }
            throw new IOException(LogCodeManager.getMessage(LogCode.JFC00250, file.getAbsolutePath()));
        }
        return new ReportWorkbookImpl(file, out);
    }

    private void replaceParamsOfSheet(Sheet sheet, Map<String, Object> params, Map<String, String> typeparams, Workbook workbook) {
        PlaceHolderValueNormalizer.splitOverCellSizeValues(params, typeparams);
        CellValueReplacer replacer = new CellValueReplacer(this.isFailedParametersToWhiteSpace(), this.getDateFormat());
        Row aRow = null;
        Cell aCell = null;
        int rowNum = sheet.getLastRowNum();
        if (rowNum > 65536) {
            rowNum = 65536;
        }
        for (int i = 0; i <= rowNum; ++i) {
            aRow = sheet.getRow(i);
            if (aRow == null) continue;
            Iterator<Cell> ite = this.getCellIterator(aRow);
            while (ite.hasNext()) {
                aCell = ite.next();
                if (aCell == null || aCell.getCellType() != CellType.STRING) continue;
                boolean processedImage = this.replaceImage(aCell, params, typeparams, i, sheet, workbook);
                boolean processedBarcode = false;
                if (!processedImage) {
                    processedBarcode = this.replaceBarcode(aCell, params, typeparams, i, sheet, workbook);
                }
                if (processedImage || processedBarcode) continue;
                replacer.replaceCellValue(aCell, params, typeparams);
            }
        }
        replacer = null;
    }

    private Iterator<Cell> getCellIterator(Row row) {
        Iterator ite = row.cellIterator();
        return ite;
    }
}

