/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.rest;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemStorerefBase;
import jp.jasminesoft.jfc.model.PresentationBase;
import jp.jasminesoft.jfc.rest.RestDataConverter;
import jp.jasminesoft.util.DateTimeUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ScheduleViewRestDataConverter<LP extends PresentationBase<LP>>
extends RestDataConverter<LP> {
    private ScheduleViewBuilder<LP, ?> builder;

    public ScheduleViewRestDataConverter(ScheduleViewBuilder<LP, ?> builder) {
        this.builder = builder;
    }

    @Override
    public Map<String, Object>[] convert(LP source) {
        if (source == null) {
            return null;
        }
        return this.builder.build(source);
    }

    static interface ScheduleViewBuilder<LP extends PresentationBase<LP>, D extends PresentationBase<D>> {
        default public String getContent(D data, String itemName) {
            Object obj = this.plGet(data, itemName);
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            return this.getContent((JFCPresentationModelitemStorerefBase[])obj);
        }

        default public Object plGet(D data, String itemName) {
            try {
                return ((PresentationBase)data).plGet(itemName);
            }
            catch (IllegalArgumentException exception) {
                return null;
            }
        }

        default public String getContent(JFCPresentationModelitemStorerefBase[] options) {
            return Arrays.stream(options).filter(option -> option.getChoose()).map(option -> option.getContent()).findFirst().orElse(null);
        }

        public Map<String, Object>[] build(LP var1);
    }

    public static class GanttchartBuilder<LP extends PresentationBase<LP>, D extends PresentationBase<D>>
    implements ScheduleViewBuilder<LP, D> {
        private final String taskIdItemName;
        private final String taskNameItemName;
        private final String resourceIdItemName;
        private final String startItemName;
        private final String endItemName;
        private final String durationItemName;
        private final String progressItemName;
        private final String dependenciesItemName;

        public GanttchartBuilder(String taskIdItemName, String taskNameItemName, String resourceIdItemName, String startItemName, String endItemName, String durationItemName, String progressItemName, String dependenciesItemName) {
            this.taskIdItemName = taskIdItemName;
            this.taskNameItemName = taskNameItemName;
            this.resourceIdItemName = resourceIdItemName;
            this.startItemName = startItemName;
            this.endItemName = endItemName;
            this.durationItemName = durationItemName;
            this.progressItemName = progressItemName;
            this.dependenciesItemName = dependenciesItemName;
        }

        protected String getTaskId(D data) {
            return (String)this.plGet(data, this.taskIdItemName);
        }

        protected String getTaskName(D data) {
            String taskName = this.getContent(data, this.taskNameItemName);
            if (StringUtils.isBlank((CharSequence)taskName)) {
                return "";
            }
            return taskName;
        }

        protected String getResourceId(D data) {
            return this.getContent(data, this.resourceIdItemName);
        }

        protected String getStart(D data) {
            return this.toISOString((String)this.plGet(data, this.startItemName));
        }

        protected String getEnd(D data) {
            return this.toISOString((String)this.plGet(data, this.endItemName));
        }

        protected String getDuration(D data) {
            return this.getContent(data, this.durationItemName);
        }

        protected String toISOString(String datetime) {
            if (StringUtils.isBlank((CharSequence)datetime)) {
                return null;
            }
            return DateTimeUtil.getSQLTimestamp((String)datetime).toInstant().atZone(ZoneId.systemDefault()).withFixedOffsetZone().toString();
        }

        protected String getProgress(D data) {
            return this.getContent(data, this.progressItemName);
        }

        protected String getDependencies(D data) {
            JFCPresentationModelitemStorerefBase[] options = (JFCPresentationModelitemStorerefBase[])this.plGet(data, this.dependenciesItemName);
            if (options == null) {
                return null;
            }
            return Arrays.stream(options).filter(option -> option.getChoose()).map(option -> option.getIdAsString()).collect(Collectors.joining(","));
        }

        protected D[] getItem(LP source) {
            Object array = ((PresentationBase)source).plGet("item");
            if (array == null) {
                return new PresentationBase[0];
            }
            return (PresentationBase[])array;
        }

        @Override
        public Map<String, Object>[] build(LP source) {
            ArrayList<Object[]> bars = new ArrayList<Object[]>();
            for (PresentationBase data : this.getItem((PresentationBase)source)) {
                bars.add(new Object[]{this.getTaskId(data), this.getTaskName(data), this.getResourceId(data), this.getStart(data), this.getEnd(data), NumberUtils.createLong((String)this.getDuration(data)), NumberUtils.toLong((String)this.getProgress(data)), this.getDependencies(data)});
            }
            HashMap<String, Object[]> ganttchart = new HashMap<String, Object[]>();
            ganttchart.put("gantt", bars.toArray(new Object[bars.size()]));
            return new Map[]{ganttchart};
        }
    }

    public static class TimelineBuilder<LP extends PresentationBase<LP>, D extends PresentationBase<D>>
    implements ScheduleViewBuilder<LP, D> {
        private final String rowLabelItemName;
        private final String barLabelItemName;
        private final String startItemName;
        private final String endItemName;

        public TimelineBuilder(String rowLabelItemName, String barLabelItemName, String startItemName, String endItemName) {
            this.rowLabelItemName = rowLabelItemName;
            this.barLabelItemName = barLabelItemName;
            this.startItemName = startItemName;
            this.endItemName = endItemName;
        }

        protected String[] getRowLabel(D data) {
            Object obj = this.plGet(data, this.rowLabelItemName);
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                return this.getRowLabel((String)obj);
            }
            return this.getRowLabel((JFCPresentationModelitemStorerefBase[])obj);
        }

        protected String[] getRowLabel(String row) {
            return new String[]{row};
        }

        protected String[] getRowLabel(JFCPresentationModelitemStorerefBase[] options) {
            return (String[])Arrays.stream(options).filter(option -> option.getChoose()).map(option -> option.getContent()).toArray(String[]::new);
        }

        protected String getBarLabel(D data) {
            return this.getContent(data, this.barLabelItemName);
        }

        protected String getStart(D data) {
            return (String)this.plGet(data, this.startItemName);
        }

        protected String getEnd(D data) {
            return (String)this.plGet(data, this.endItemName);
        }

        protected D[] getItem(LP source) {
            Object array = ((PresentationBase)source).plGet("item");
            if (array == null) {
                return new PresentationBase[0];
            }
            return (PresentationBase[])array;
        }

        @Override
        public Map<String, Object>[] build(LP source) {
            ArrayList<String[]> bars = new ArrayList<String[]>();
            for (PresentationBase data : this.getItem((PresentationBase)source)) {
                if (this.getStart(data) == null || this.getEnd(data) == null || this.getBarLabel(data) == null || ArrayUtils.isEmpty((Object[])this.getRowLabel(data))) continue;
                String[] bar = new String[]{null, this.getBarLabel(data), DateTimeUtil.getSQLTimestamp((String)this.getStart(data)).toInstant().atZone(ZoneId.systemDefault()).withFixedOffsetZone().toString(), DateTimeUtil.getSQLTimestamp((String)this.getEnd(data)).toInstant().atZone(ZoneId.systemDefault()).withFixedOffsetZone().toString()};
                for (String row : this.getRowLabel(data)) {
                    String[] copy = (String[])bar.clone();
                    copy[0] = row;
                    bars.add(copy);
                }
            }
            HashMap<String, String[][]> timeline = new HashMap<String, String[][]>();
            timeline.put("timeline", (String[][])bars.toArray((T[])new String[bars.size()][4]));
            return new Map[]{timeline};
        }
    }
}

