/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.service;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletConfig;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.JprincipalXmlCreator;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.controller.InitLoaderFormInfoBean;
import jp.jasminesoft.jfc.core.util.AbstractDomainSupport;
import jp.jasminesoft.jfc.initdb.PathUtil;
import jp.jasminesoft.jfc.initdb.XMLLoader;
import jp.jasminesoft.jfc.initdb.XMLLoaderActionListener;
import jp.jasminesoft.jfc.initdb.conf.Config;
import jp.jasminesoft.jfc.initdb.conf.Directory;
import jp.jasminesoft.jfc.initdb.conf.IConfigChoice;
import jp.jasminesoft.util.HolidayManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

public class InitLoaderBaseService {
    private static final Logger logger = LogManager.getLogger((String)InitLoaderBaseService.class.getName());
    private static final String JuserModelId = "juser";
    public static final String JprincipalModelId = "jprincipal";
    public static final String JcategoryModelId = "jcategory";
    public static final String JfcpreferenceitemModelId = "jfcpreferenceitem";
    public static final String JFCREMINDER_MODELID = "jfcreminder";
    protected static final String ExportCountMapAttrName = "__jfc_InitLoaderBaseAction_exportCountMap";
    public static final String InitloaderPropertiesFilename = "initloader.properties";
    public static final String InitloaderPropertiesFileCountHeader = "InitLoader.file.count.";
    private static final String INITALDATA_LABEL_RKEY = "__jfc_common.text.import.initdata";
    protected String configPath = null;
    protected String initdataPath = null;
    protected String importParentPath = null;
    protected String exportParentPath = null;
    protected String exportDirectoryPrefix = null;
    protected int errorCount = 0;
    protected int successCount = 0;
    protected String[] importInitdataModelIds = new String[]{"jfcmodel", "jfcmodel4dm", "jfcjob"};
    @Autowired
    @Qualifier(value="DomainSupport")
    protected AbstractDomainSupport domainSupport;
    private JFCErrorManager errorManager;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private ServletConfig servletConfig;
    private static long tablePathMap_confFile_lastModified = -1L;
    private static long tablePathMap_confFile_length = -1L;
    private static Map<String, String> tablePathMap;

    public String[] getImportInitdataModelIds() {
        return this.importInitdataModelIds;
    }

    public void setImportInitdataModelIds(String[] importInitdataModelIds) {
        this.importInitdataModelIds = importInitdataModelIds;
    }

    public JFCErrorManager getErrorManager() {
        return this.errorManager;
    }

    public void setErrorManager(JFCErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getInitdataPath() {
        return this.initdataPath;
    }

    public void resetCount() {
        this.errorCount = 0;
        this.successCount = 0;
    }

    public void do_execute(String[] args, XMLLoaderActionListener listener) {
    }

    public boolean do_original_import(ActionParameter p, String[] checkedTableList, InitLoaderFormInfoBean formInfo) {
        String[] appendargs = new String[]{};
        return this.importDirectorys(p, checkedTableList, appendargs, "", formInfo);
    }

    public boolean do_original_convert(ActionParameter p, String[] checkedTableList, InitLoaderFormInfoBean formInfo) {
        String[] appendargs = new String[]{"-convert_from_old", "true"};
        return this.importDirectorys(p, checkedTableList, appendargs, ".olddata", formInfo);
    }

    protected boolean importDirectorys(ActionParameter p, String[] checkedTableList, String[] appendargs, String messageFooter, InitLoaderFormInfoBean formInfo) {
        boolean importinitdata;
        Object importdir;
        String importDirectory = null;
        if (formInfo != null) {
            importDirectory = formInfo.getImportDirectory();
        }
        if (importDirectory == null || importDirectory.length() == 0) {
            p.errors.addJfcerror(this.getErrorManager().getJfcerror("error.initloader_action.noselected.import_dir", p.locale));
            return true;
        }
        String initdataLabel = JFCUtils.getRValue(INITALDATA_LABEL_RKEY, p.locale);
        if (importDirectory.equals(initdataLabel)) {
            importdir = this.initdataPath;
            importinitdata = true;
        } else {
            if (this.importParentPath == null || this.importParentPath.length() == 0) {
                this.importParentPath = ".";
            }
            importdir = this.importParentPath + File.separator + importDirectory;
            importinitdata = false;
        }
        this.sql(p, "jfc_beforeimport");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < checkedTableList.length; ++i) {
            String checkedTable = checkedTableList[i];
            if (JuserModelId.equals(checkedTable)) {
                if (!importinitdata) {
                    if (this.createJprincipalXml(p, (String)importdir)) {
                        ++this.errorCount;
                        continue;
                    }
                } else if (this.createEmptyJprincipalXml(p)) {
                    ++this.errorCount;
                    continue;
                }
                this.importDirectory_juser(p, checkedTable, appendargs, (String)importdir, formInfo);
                continue;
            }
            sb.append(checkedTable);
            sb.append(" ");
        }
        if (sb.length() > 0) {
            this.importDirectory(p, sb.toString(), appendargs, (String)importdir, formInfo);
            if (this.importInitdataModelIds != null && this.importInitdataModelIds.length > 0) {
                String modelids = String.join((CharSequence)" ", this.importInitdataModelIds);
                this.importDirectory(p, modelids, appendargs, this.initdataPath, formInfo);
            }
        }
        this.sql(p, "jfc_afterimport");
        if (this.errorCount == 0) {
            p.errors.addJfcinfo(this.getErrorManager().getJfcinfo("success.initloader_action.import" + messageFooter, p.locale));
            Object[] o = new Object[]{importDirectory, String.valueOf(this.successCount), String.valueOf(this.errorCount)};
            p.errors.addJfcinfo(this.getErrorManager().getJfcinfo("success.initloader_action.report", o, p.locale));
        } else {
            p.errors.addJfcerror(this.getErrorManager().getJfcerror("error.initloader_action.import" + messageFooter, p.locale));
            Object[] o = new Object[]{importDirectory, String.valueOf(this.successCount), String.valueOf(this.errorCount)};
            p.errors.addJfcerror(this.getErrorManager().getJfcerror("success.initloader_action.report", o, p.locale));
        }
        return false;
    }

    private boolean createJprincipalXml(ActionParameter p, String source_importdir) {
        String initdata_importdir = this.initdataPath;
        if (!new File(initdata_importdir).exists()) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00700), LogCodeManager.getMessage(LogCode.JFC00700, p.user, initdata_importdir));
            ++this.errorCount;
            return true;
        }
        try {
            JprincipalXmlCreator.create(initdata_importdir, source_importdir);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00700), LogCodeManager.getMessage(LogCode.JFC00700, p.user, e.getMessage()));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private boolean createEmptyJprincipalXml(ActionParameter p) {
        try {
            JprincipalXmlCreator.createEmptyFile();
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00700), LogCodeManager.getMessage(LogCode.JFC00700, p.user, e.getMessage()));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void importDirectory_juser(ActionParameter p, String checkedTable, String[] appendargs, String source_importdir, InitLoaderFormInfoBean formInfo) {
        String initdata_importdir = this.initdataPath;
        int tempErrorCount = this.errorCount;
        this.importDirectory(p, JcategoryModelId, appendargs, initdata_importdir, formInfo);
        if (tempErrorCount != this.errorCount) {
            return;
        }
        this.importDirectory(p, JprincipalModelId, appendargs, initdata_importdir, formInfo);
        if (tempErrorCount != this.errorCount) {
            return;
        }
        tempErrorCount = this.errorCount;
        this.importDirectory(p, JfcpreferenceitemModelId, appendargs, source_importdir, formInfo);
        if (tempErrorCount != this.errorCount) {
            return;
        }
        if (this.existsJfcReminder(p)) {
            this.importDirectory(p, JFCREMINDER_MODELID, appendargs, source_importdir, formInfo);
        }
        this.importDirectory(p, JuserModelId, appendargs, source_importdir, formInfo);
    }

    protected boolean existsJfcReminder(ActionParameter p) {
        for (String[] info : this.getTableList(p)) {
            if (!JFCREMINDER_MODELID.equals(info[0])) continue;
            return true;
        }
        return false;
    }

    private void importDirectory(ActionParameter p, String checkedTable, String[] appendargs, String importdir, InitLoaderFormInfoBean formInfo) {
        int j;
        boolean tableInitialize = false;
        if (formInfo != null) {
            tableInitialize = formInfo.getTableInitialize();
        }
        XMLLoaderActionListener listener = this.createXMLLoaderActionListener(p);
        if (tableInitialize) {
            String[] args1 = new String[]{"drop", "-t", checkedTable, "-c", this.configPath};
            this.do_execute(args1, listener);
            String[] args2 = new String[]{"create", "-t", checkedTable, "-c", this.configPath};
            this.do_execute(args2, listener);
        }
        String[] basicargs = new String[]{"import", "-t", checkedTable, "-c", this.configPath, "-d", importdir, "-init_dir_path", this.initdataPath};
        String[] args = new String[basicargs.length + appendargs.length];
        for (j = 0; j < basicargs.length; ++j) {
            args[j] = basicargs[j];
        }
        for (j = 0; j < appendargs.length; ++j) {
            args[basicargs.length + j] = appendargs[j];
        }
        this.do_execute(args, listener);
    }

    protected void sql(ActionParameter p, String group) {
        XMLLoaderActionListener listener = this.createXMLLoaderActionListener(p);
        String[] args = new String[]{"sql", "-g", group, "-c", this.configPath};
        this.do_execute(args, listener);
    }

    public void do_original_export(ActionParameter p, String[] checkedTableList, InitLoaderFormInfoBean formInfo) {
        if (this.exportParentPath == null || this.exportParentPath.length() == 0) {
            this.exportParentPath = ".";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String domainIdPrefix = Optional.ofNullable(this.domainSupport.domainId()).map(domainId -> domainId + "_").orElse("");
        String exportDirectory = this.exportDirectoryPrefix + domainIdPrefix + sdf.format(new Date());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < checkedTableList.length; ++i) {
            String checkedTable = checkedTableList[i];
            if (JuserModelId.equals(checkedTable)) {
                sb.append(JcategoryModelId);
                sb.append(" ");
                sb.append(JprincipalModelId);
                sb.append(" ");
                sb.append(JfcpreferenceitemModelId);
                sb.append(" ");
                sb.append(JuserModelId);
                sb.append(" ");
                continue;
            }
            sb.append(checkedTable);
            sb.append(" ");
        }
        if (sb.length() > 0) {
            sb.append("seq");
            sb.append(" ");
            this.exportDirectory(p, sb.toString(), exportDirectory, formInfo);
        }
        if (this.errorCount == 0) {
            p.errors.addJfcinfo(this.getErrorManager().getJfcinfo("success.initloader_action.export", p.locale));
            Object[] o = new Object[]{exportDirectory, String.valueOf(this.successCount), String.valueOf(this.errorCount)};
            p.errors.addJfcinfo(this.getErrorManager().getJfcinfo("success.initloader_action.report", o, p.locale));
        } else {
            p.errors.addJfcerror(this.getErrorManager().getJfcerror("error.initloader_action.export", p.locale));
            Object[] o = new Object[]{exportDirectory, String.valueOf(this.successCount), String.valueOf(this.errorCount)};
            p.errors.addJfcerror(this.getErrorManager().getJfcerror("success.initloader_action.report", o, p.locale));
        }
    }

    private Map<String, Integer> getExportCountMap(ActionParameter p) {
        return (Map)p.request.getAttribute(ExportCountMapAttrName);
    }

    public void saveExportConfigFile(String exportDirectory, Collection<String> tablelist, ActionParameter p) {
        Map<String, Integer> exportCountMap = this.getExportCountMap(p);
        this.saveExportConfigFile(exportDirectory, tablelist, exportCountMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveExportConfigFile(String exportDirectory, Collection<String> tablelist, Map<String, Integer> exportCountMap) {
        BufferedOutputStream bufferedOutputStream;
        if (exportCountMap == null) return;
        if (exportCountMap.size() == 0) {
            return;
        }
        if (tablelist != null) {
            for (String string : tablelist) {
                if (exportCountMap.containsKey(string)) continue;
                exportCountMap.put(string, 0);
            }
        }
        Properties props = new Properties();
        for (Map.Entry<String, Integer> entry : exportCountMap.entrySet()) {
            props.setProperty(InitloaderPropertiesFileCountHeader + entry.getKey(), entry.getValue().toString());
        }
        File file = new File(exportDirectory, InitloaderPropertiesFilename);
        OutputStream outputStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            props.store(bufferedOutputStream, null);
            if (bufferedOutputStream == null) return;
        }
        catch (IOException e) {
            logger.error("(admin@localhost) Failed to save initloader config file " + file, (Throwable)e);
            return;
        }
        try {
            ((OutputStream)bufferedOutputStream).close();
            return;
        }
        catch (IOException e) {
            logger.error("(admin@localhost) Failed to close output stream file " + file, (Throwable)e);
            return;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error("(admin@localhost) Failed to close output stream file " + file, (Throwable)e);
                }
            }
        }
    }

    private void exportDirectory(ActionParameter p, String checkedTable, String exportDirectory, InitLoaderFormInfoBean formInfo) {
        XMLLoaderActionListener listener = this.createXMLLoaderActionListener(p);
        Object[] args = new String[]{"export", "-t", checkedTable, "-c", this.configPath, "-d", this.exportParentPath + File.separator + exportDirectory};
        if (formInfo != null && formInfo.getUseAsZip()) {
            args = (String[])ArrayUtils.add((Object[])args, (Object)"-zip");
        }
        this.do_execute((String[])args, listener);
    }

    public static synchronized Map<String, String> createTablePathMap(String confPath) {
        block6: {
            File confFile = new File(confPath);
            HashMap<String, String> _tablePathMap = new HashMap<String, String>();
            if (!confFile.exists()) {
                return _tablePathMap;
            }
            if (tablePathMap != null && tablePathMap_confFile_lastModified == confFile.lastModified() && tablePathMap_confFile_length == confFile.length()) {
                return tablePathMap;
            }
            try {
                Config config = XMLLoader.loadConfig(confFile);
                IConfigChoice[] icc = config.getContent();
                if (icc != null) {
                    for (int i = 0; i < icc.length; ++i) {
                        if (!(icc[i] instanceof Directory)) continue;
                        Directory directory = (Directory)icc[i];
                        _tablePathMap.put(directory.getTablename(), directory.getContent());
                    }
                }
                tablePathMap = _tablePathMap;
                tablePathMap_confFile_lastModified = confFile.lastModified();
                tablePathMap_confFile_length = confFile.length();
            }
            catch (Exception e) {
                tablePathMap = null;
                logger.log(LogCodeManager.getPriority(LogCode.JFC00240), LogCodeManager.getMessage(LogCode.JFC00240, confFile.getAbsolutePath(), e.getMessage()));
                logger.debug((Object)e);
                if (!logger.isDebugEnabled()) break block6;
                e.printStackTrace();
            }
        }
        return tablePathMap;
    }

    public String[] getCheckedTableList(ActionParameter p, InitLoaderFormInfoBean formInfo) {
        StringBuffer sb = new StringBuffer();
        String delimiter = "/";
        boolean isSelect = false;
        for (Map.Entry<String, InitLoaderFormInfoBean.TableBean> entry : formInfo.getTableList().entrySet()) {
            String key = entry.getKey();
            InitLoaderFormInfoBean.TableBean tbean = entry.getValue();
            if (tbean == null || !tbean.getChecked()) continue;
            sb.append(key);
            sb.append(delimiter);
            isSelect = true;
        }
        if (isSelect) {
            return sb.toString().split(delimiter);
        }
        return new String[0];
    }

    public String getImportDirectory(ActionParameter p, String importDirectoryNum, InitLoaderFormInfoBean formInfo) {
        String[] importDirectoryList = formInfo.getImportDirectoryList();
        return importDirectoryList[Integer.parseInt(importDirectoryNum)];
    }

    public void getImportDirectoryList(ActionParameter p, InitLoaderFormInfoBean formInfo) {
        if (this.importParentPath == null || this.importParentPath.length() == 0) {
            return;
        }
        if (formInfo == null) {
            return;
        }
        String[] importDirectoryList = null;
        TreeMap<String, Map<String, Integer>> importDirectoryTableDatanum = new TreeMap<String, Map<String, Integer>>();
        File target = new File(this.importParentPath);
        if (!target.exists()) {
            return;
        }
        File[] files = target.listFiles(new PrefixFileFilter(this.exportDirectoryPrefix));
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < files.length; ++i) {
            String fname = files[i].getName();
            if (files[i].isDirectory()) {
                list.add(fname);
                importDirectoryTableDatanum.put(fname, this.getTableDatanum(formInfo, files[i]));
                continue;
            }
            if (!fname.endsWith(".zip")) continue;
            fname = fname.substring(0, fname.length() - ".zip".length());
            list.add(fname + ".zip");
            importDirectoryTableDatanum.put(fname + ".zip", this.getTableDatanum(formInfo, files[i]));
        }
        if (list != null && list.size() > 0) {
            Collections.sort(list);
            Collections.reverse(list);
        }
        String initdataLabel = JFCUtils.getRValue(INITALDATA_LABEL_RKEY, p.locale);
        list.add(initdataLabel);
        importDirectoryTableDatanum.put(initdataLabel, this.getTableDatanum(formInfo, new File(this.initdataPath)));
        importDirectoryList = list.toArray(new String[0]);
        formInfo.setImportDirectory(importDirectoryList[0]);
        formInfo.setImportDirectoryList(importDirectoryList);
        formInfo.setImportDirectoryTableDatanum(importDirectoryTableDatanum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> getTableDatanum(InitLoaderFormInfoBean formInfo, File file) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        if (file.getName().endsWith(".zip")) {
            ZipFile zf = null;
            try {
                zf = new ZipFile(file.getAbsolutePath());
                this.createTableDatumMapByZip(formInfo, map, zf);
            }
            catch (IOException e) {
                logger.error("(admin@localhost) Failed to process zip file " + file, (Throwable)e);
            }
            finally {
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (IOException e) {
                        logger.error("(admin@localhost) Failed to close zip file " + file, (Throwable)e);
                    }
                }
            }
            return map;
        }
        Properties props = new Properties();
        File initloaderprop = new File(file, InitloaderPropertiesFilename);
        if (initloaderprop.exists()) {
            InputStream istream = null;
            try {
                istream = new FileInputStream(initloaderprop);
                istream = new BufferedInputStream(istream);
                props.load(istream);
            }
            catch (IOException e) {
                logger.error("(admin@localhost) Failed to load initloader.properties file " + initloaderprop, (Throwable)e);
            }
            finally {
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (IOException e) {
                        logger.error("(admin@localhost) Failed to close input stream file " + initloaderprop, (Throwable)e);
                    }
                }
            }
            this.createTableDatumMapByProperties(formInfo, map, props);
            return map;
        }
        for (Map.Entry<String, InitLoaderFormInfoBean.TableBean> entry : formInfo.getTableList().entrySet()) {
            String[] files;
            InitLoaderFormInfoBean.TableBean tbean = entry.getValue();
            String tablename = PathUtil.getModelIdFromDirectoryContent(tbean.getPath());
            File initdir = new File(file, tbean.getPath());
            String[] stringArray = files = initdir != null ? initdir.list() : null;
            if (files != null && initdir.exists()) {
                map.put(tablename, files.length);
                continue;
            }
            map.put(tablename, 0);
        }
        this.saveExportConfigFile(file.toString(), null, map);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTableDatumMapByZip(InitLoaderFormInfoBean formInfo, Map<String, Integer> map, ZipFile zf) throws IOException {
        Properties props = new Properties();
        Enumeration<? extends ZipEntry> e = zf.entries();
        String dir = null;
        ZipEntry archivelistEntry = null;
        int maxCheckFileNum = 10;
        for (int i = 0; i < 10; ++i) {
            if (!e.hasMoreElements()) {
                logger.error("(admin@localhost) empty zip file " + zf.getName());
                return false;
            }
            ZipEntry zipEntry = e.nextElement();
            String name = zipEntry.getName();
            if (name.endsWith(InitloaderPropertiesFilename)) {
                archivelistEntry = zipEntry;
                break;
            }
            int index = name.indexOf(47);
            if (index > 0) {
                dir = name.substring(0, index);
                break;
            }
            if (!zipEntry.isDirectory()) continue;
            dir = name;
            break;
        }
        if (archivelistEntry == null && dir == null) {
            logger.warn("No found folder or initloader.properties in zip file " + zf.getName());
            return false;
        }
        String archivelistname = null;
        if (archivelistEntry == null) {
            archivelistname = dir + "/initloader.properties";
            archivelistEntry = zf.getEntry(archivelistname);
        }
        if (archivelistEntry == null) {
            logger.warn("No archivelist file " + archivelistname + " in zip file " + zf.getName());
            return false;
        }
        try (InputStream is = zf.getInputStream(archivelistEntry);){
            props.load(is);
        }
        this.createTableDatumMapByProperties(formInfo, map, props);
        return true;
    }

    private void createTableDatumMapByProperties(InitLoaderFormInfoBean formInfo, Map<String, Integer> map, Properties props) {
        for (Map.Entry<String, InitLoaderFormInfoBean.TableBean> entry : formInfo.getTableList().entrySet()) {
            InitLoaderFormInfoBean.TableBean tbean = entry.getValue();
            String path = PathUtil.getModelIdFromDirectoryContent(tbean.getPath());
            String tablename = path;
            String key = InitloaderPropertiesFileCountHeader + tablename;
            String tmp = props.getProperty(key);
            if (!StringUtils.isNotEmpty((CharSequence)tmp)) continue;
            try {
                int size = Integer.valueOf(tmp);
                map.put(tablename, size);
            }
            catch (NumberFormatException e) {
                logger.error("(admin@localhost) The key '" + path + "' is not number type, value=" + tmp, (Throwable)e);
            }
        }
    }

    public XMLLoaderActionListener createXMLLoaderActionListener(ActionParameter p) {
        return new InitLoaderBaseActionXMLLoaderActionListener(p);
    }

    public String[][] getTableList(ActionParameter p) {
        return null;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getImportParentPath() {
        return this.importParentPath;
    }

    public String getExportParentPath() {
        return this.exportParentPath;
    }

    public String getExportDirectoryPrefix() {
        return this.exportDirectoryPrefix;
    }

    static class PrefixFileFilter
    implements FileFilter {
        String _prefix = null;

        public PrefixFileFilter(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public boolean accept(File path) {
            String fileName = path.getName();
            return fileName.startsWith(this._prefix);
        }
    }

    class InitLoaderBaseActionXMLLoaderActionListener
    implements XMLLoaderActionListener {
        private ActionParameter p;

        InitLoaderBaseActionXMLLoaderActionListener(ActionParameter p) {
            this.p = p;
            HolidayManager.getInstance().reset();
        }

        @Override
        public void init(XMLLoader loader, String filename) throws IllegalStateException {
        }

        @Override
        public void processEnd(XMLLoader loader, String filename) {
        }

        @Override
        public void successImport(XMLLoader loader, Directory dir, File f) {
            ++InitLoaderBaseService.this.successCount;
        }

        @Override
        public void errorImport(XMLLoader loader, Directory dir, File f, Exception e) {
            ++InitLoaderBaseService.this.errorCount;
        }

        @Override
        public void successUpdate(XMLLoader loader, Directory dir, File f) {
            ++InitLoaderBaseService.this.successCount;
        }

        @Override
        public void errorUpdate(XMLLoader loader, Directory dir, File f, Exception e) {
            ++InitLoaderBaseService.this.errorCount;
        }

        @Override
        public void successExport(XMLLoader loader, Directory dir, File f) {
            Integer cnt;
            ++InitLoaderBaseService.this.successCount;
            Map<String, Integer> exportCountMap = InitLoaderBaseService.this.getExportCountMap(this.p);
            if (exportCountMap == null) {
                exportCountMap = new HashMap<String, Integer>();
                this.p.request.setAttribute(InitLoaderBaseService.ExportCountMapAttrName, exportCountMap);
            }
            cnt = (cnt = exportCountMap.get(dir.getTablename())) == null ? Integer.valueOf(1) : Integer.valueOf(cnt + 1);
            exportCountMap.put(dir.getTablename(), cnt);
        }

        @Override
        public void errorExport(XMLLoader loader, Directory dir, File f, Exception e) {
            ++InitLoaderBaseService.this.errorCount;
        }
    }
}

