/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.service;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.core.exception.BusinessLogicException;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.dao.DataBindingContext;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.dao.IScroller;
import jp.jasminesoft.jfc.dao.JFCGenericDao;
import jp.jasminesoft.jfc.dao.JFCHibernateDao;
import jp.jasminesoft.jfc.dao.Updator;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.jfc.service.JFCNewTransactionEntityService;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class JFCAbstractEntityService<E extends ContainerBase<E>, PK extends Serializable>
implements JFCEntityService<E, PK> {
    private static final Logger logger = LogManager.getLogger(JFCAbstractEntityService.class);
    protected JFCGenericDao<E, PK> dao;
    protected EntityHelper<E, PK> entityHelper;
    @Autowired
    @Qualifier(value="JFCNewTransactionEntityService")
    JFCNewTransactionEntityService<E, PK> newTransactionEntityService;

    public void setDao(JFCGenericDao<E, PK> dao) {
        this.dao = dao;
    }

    public void setEntityHelper(EntityHelper<E, PK> helper) {
        this.entityHelper = helper;
    }

    public Session getCurrentSession() {
        return this.dao.getCurrentSession();
    }

    public ActionParameterContainer getActionParameterContainer() {
        return null;
    }

    @Override
    public JFCEntityService<E, PK> newTransactionEntityService() {
        this.newTransactionEntityService.setEntityService(this);
        return this.newTransactionEntityService;
    }

    @Override
    public void insert(E entity) {
        this.dao.save(entity);
        this.entityHelper.saveAsGeneration(entity, 1, this.getActionParameterContainer().get());
        this.insertJfcworkstate(entity);
        this.updateRelatedModelsInsertTransaction(entity);
    }

    protected void updateRelatedModelsInsertTransaction(E entity) {
        this.script(entity, this.getActionParameterContainer().get(), new Object(){}.getClass().getEnclosingMethod().getName());
    }

    protected void insertJfcworkstate(E entity) {
    }

    @Override
    public void update(E entity) {
        this.dao.update(entity);
        if (!this.isWorkflowUpdate()) {
            this.entityHelper.saveAsGeneration(entity, 3, this.getActionParameterContainer().get());
        }
        this.updateRelatedModelsUpdateTransaction(entity);
    }

    @Override
    public void update(E entity, boolean checkLocked) {
        this.dao.update(entity, checkLocked);
        if (!this.isWorkflowUpdate()) {
            this.entityHelper.saveAsGeneration(entity, 3, this.getActionParameterContainer().get());
        }
        this.updateRelatedModelsUpdateTransaction(entity);
    }

    @Override
    public void update(PK primarykey, Updator<E> updator) {
        ContainerBase entity = (ContainerBase)this.dao.update(primarykey, updator);
        if (!this.isWorkflowUpdate()) {
            this.entityHelper.saveAsGeneration(entity, 3, this.getActionParameterContainer().get());
        }
        this.updateRelatedModelsUpdateTransaction(entity);
    }

    private boolean isWorkflowUpdate() {
        ActionParameter p = this.getActionParameterContainer().get();
        if (p != null && p.request != null) {
            Enumeration em = p.request.getAttributeNames();
            while (em.hasMoreElements()) {
                String _s = (String)em.nextElement();
                if (!_s.startsWith("__jfc_workflowupdate_")) continue;
                return true;
            }
        }
        return false;
    }

    protected void updateRelatedModelsUpdateTransaction(E entity) {
        this.script(entity, this.getActionParameterContainer().get(), new Object(){}.getClass().getEnclosingMethod().getName());
    }

    @Override
    public E findById(PK pkey) {
        return (E)((ContainerBase)this.dao.get(pkey));
    }

    @Override
    public E findById(PK pkey, DataBindingContext context) {
        return (E)((ContainerBase)this.dao.get(pkey, context));
    }

    @Override
    public E findById(PK pkey, boolean forUpdate) {
        return (E)((ContainerBase)this.dao.get(pkey, forUpdate));
    }

    @Override
    public E findById(PK pkey, boolean forUpdate, DataBindingContext context) {
        return (E)((ContainerBase)this.dao.get(pkey, forUpdate, context));
    }

    @Override
    public List<E> find() {
        return this.dao.findAll();
    }

    @Override
    public List<E> find(DataBindingContext context) {
        return this.dao.findAll(context);
    }

    @Override
    public List<E> find(DetachedCriteria criteria) {
        return this.dao.findByCriteria(criteria);
    }

    @Override
    public List<E> find(DetachedCriteria criteria, DataBindingContext context) {
        return this.dao.findByCriteria(criteria, context);
    }

    @Override
    public List<E> find(FinderContext<?> finderContext) {
        if (finderContext == null) {
            return this.find();
        }
        List<E> results = this.dao.find(finderContext);
        this.updateCount(results, finderContext);
        return results;
    }

    @Override
    public int count(FinderContext<?> finderContext) {
        int count = this.dao.count(finderContext);
        finderContext.updateCount(count);
        return count;
    }

    @Override
    public int count(DetachedCriteria criteria) {
        return this.dao.count(criteria);
    }

    @Override
    public int count() {
        return this.dao.countAll();
    }

    @Override
    public List<PK> findKeys(FinderContext<?> finderContext) {
        return this.dao.findKeys(finderContext);
    }

    @Override
    public List<PK> findKeys(FinderContext<?> finderContext, boolean updateCount) {
        List<PK> results = this.dao.findKeys(finderContext);
        if (updateCount) {
            this.updateCount(results, finderContext);
        }
        return results;
    }

    public void updateCount(List<?> results, final FinderContext<?> finderContext) {
        if (results == JFCHibernateDao.SKIP_SEARCH_EMPTY_LIST) {
            return;
        }
        finderContext.updateCount(results.size(), new FinderContext.CountUpdator(){

            @Override
            protected int count() {
                return JFCAbstractEntityService.this.dao.count(finderContext);
            }
        });
    }

    @Override
    public List<PK> findKeys(DetachedCriteria criteria, int firstResult, int maxResults) {
        return this.dao.findKeys(criteria, firstResult, maxResults);
    }

    @Override
    public void scroll(IScroller<E> scroller) {
        this.dao.scroll(scroller);
    }

    @Override
    public <T> List<T> distinct(PropertyMeta<T> property) {
        return this.dao.distinct(property);
    }

    @Override
    public E delete(PK pkey) {
        return this.delete(pkey, false);
    }

    @Override
    public E delete(PK pkey, boolean lock) {
        ContainerBase entity = (ContainerBase)this.dao.deleteById(pkey, lock);
        this.entityHelper.saveAsGeneration(entity, 4, this.getActionParameterContainer().get());
        this.updateRelatedModelsDeleteTransaction(entity);
        this.cascadeDelete(entity);
        return (E)entity;
    }

    @Override
    public E logicalDelete(PK pkey) {
        ContainerBase entity = (ContainerBase)this.dao.get(pkey, true);
        if (entity == null) {
            String entityName = null;
            if (this.dao instanceof JFCHibernateDao) {
                entityName = ((JFCHibernateDao)this.dao).getEntityClass().getName();
            }
            throw new ObjectNotFoundException(pkey, entityName);
        }
        this.dao.update(this.entityHelper.logicalDelete(entity, this.getActionParameterContainer().get()), true);
        this.entityHelper.saveAsGeneration(entity, 5, this.getActionParameterContainer().get());
        this.updateRelatedModelsDeleteTransaction(entity);
        return (E)entity;
    }

    protected void updateRelatedModelsDeleteTransaction(E entity) {
        this.script(entity, this.getActionParameterContainer().get(), new Object(){}.getClass().getEnclosingMethod().getName());
    }

    protected void cascadeDelete(E entity) {
        this.script(entity, this.getActionParameterContainer().get(), new Object(){}.getClass().getEnclosingMethod().getName());
    }

    protected void script(E entity, ActionParameter p, String methodName) {
        if (StringUtils.isBlank((CharSequence)methodName)) {
            return;
        }
        if (entity == null) {
            logger.debug("Skip calling script because No entity is found. " + methodName, (Throwable)new Exception());
            return;
        }
        String modelId = StoreModelUtils.getModelId(entity.getClass());
        p.request.setAttribute("__jsobj_" + modelId, entity);
        String status = new ScriptCodeRunner(modelId).process(this.getClass().getName(), methodName, p);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            throw new BusinessLogicException(status);
        }
    }

    @Override
    public void flush() {
        try {
            this.getCurrentSession().flush();
        }
        catch (HibernateException e) {
            logger.error("failed flash hibernate session", (Throwable)e);
        }
    }
}

