/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.servlet;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.servlet.auth.oauth2.AbstractAuthorizationCodeServlet;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.servlet.GoogleOAuth2Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class GoogleAuthorizationCodeServlet
extends AbstractAuthorizationCodeServlet {
    private static final Logger logger = LogManager.getLogger((String)GoogleAuthorizationCodeServlet.class.getName());
    @Autowired
    private ApplicationContext appctx;
    @Autowired
    private GoogleOAuth2Util util;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Credential credential = this.getCredential();
        logger.debug("doGet " + credential);
        logger.debug("appctx " + this.appctx);
        this.util.logCredential(credential);
        String redirectUrl = this.util.getWebapiRedirectUri(request);
        response.sendRedirect(redirectUrl);
    }

    private GoogleOAuth2Util.UserInfo getUserInfo(String accessToken) throws IOException {
        return this.util.getUserInfo(accessToken);
    }

    protected String getRedirectUri(HttpServletRequest request) throws ServletException, IOException {
        String redirectUrl = this.util.getRedirectUri(request);
        return redirectUrl;
    }

    protected AuthorizationCodeFlow initializeFlow() throws IOException {
        return this.util.initializeFlow();
    }

    protected String getUserId(HttpServletRequest req) throws ServletException, IOException {
        return this.util.getUserId(req);
    }
}

