/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.servlet;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.DataStoreCredentialRefreshListener;
import com.google.api.client.auth.oauth2.StoredCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleOAuth2Util {
    private static final Logger logger = LogManager.getLogger((String)GoogleOAuth2Util.class.getName());
    private static final String CLIENT_SECRET_FILE = "client_secret.json";
    private static final String DATASTORE_DIR = "datastore";
    private static final List<String> AUTHORIZATION_SCOPES = Arrays.asList("https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/userinfo.profile", "https://mail.google.com/");
    private static final String USERID = "mailuser";
    private DataStore<StoredCredential> dataStore;
    private AuthorizationCodeFlow flow;
    public static final String CANNNOT_READ_CLIENTSECRET_JFCERRORKEY = "error.GoogleOAuth2Util.cannot_read_clientsecret";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfo getUserInfo(String accessToken) throws IOException {
        String surl = "https://www.googleapis.com/oauth2/v1/userinfo?access_token=" + accessToken;
        NetHttpTransport httpTransport = new NetHttpTransport();
        try {
            UserInfo userInfo;
            HttpRequestFactory requestFactory = httpTransport.createRequestFactory();
            GenericUrl url = new GenericUrl(surl);
            HttpRequest req = requestFactory.buildGetRequest(url);
            HttpResponse res = req.execute();
            try {
                logger.debug((Object)res.getStatusCode());
                logger.debug(res.getContentType());
                String json = res.parseAsString();
                logger.debug(json);
                UserInfo userinfo = (UserInfo)new Gson().fromJson(json, UserInfo.class);
                logger.debug((Object)userinfo);
                userInfo = userinfo;
            }
            catch (Throwable throwable) {
                res.disconnect();
                throw throwable;
            }
            res.disconnect();
            return userInfo;
        }
        finally {
            httpTransport.shutdown();
        }
    }

    public String getWebapiRedirectUri(HttpServletRequest request) {
        String servletpath = "/webapi.do";
        String redirectUrl = this.getRedirectUri(request, "/webapi.do");
        logger.debug("redirectUrl " + redirectUrl);
        return redirectUrl;
    }

    public String getRedirectUri(HttpServletRequest request) throws ServletException, IOException {
        String servletpath = "/webapi/oauth2callback/google";
        String redirectUrl = this.getRedirectUri(request, "/webapi/oauth2callback/google");
        logger.debug("redirectUrl " + redirectUrl);
        return redirectUrl;
    }

    public String getRedirectUri(HttpServletRequest request, String servletpath) {
        String urls = request.getRequestURL().toString();
        GenericUrl url = new GenericUrl(urls);
        String redirectUrl = url.buildAuthority() + request.getContextPath() + servletpath;
        return redirectUrl;
    }

    public File getClientSecretFile() {
        return new File(CLIENT_SECRET_FILE);
    }

    public AuthorizationCodeFlow initializeFlow() throws IOException {
        File clientsecretFile = this.getClientSecretFile();
        if (!clientsecretFile.canRead()) {
            logger.error("clientsecretFile " + clientsecretFile + " can't read");
            return null;
        }
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)GsonFactory.getDefaultInstance(), (Reader)new FileReader(clientsecretFile));
        DataStore<StoredCredential> dataStore = this.getDataStore();
        return new GoogleAuthorizationCodeFlow.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), clientSecrets, AUTHORIZATION_SCOPES).setCredentialDataStore(dataStore).setAccessType("offline").setApprovalPrompt("force").addRefreshListener((CredentialRefreshListener)new DataStoreCredentialRefreshListener(USERID, dataStore)).build();
    }

    protected DataStore<StoredCredential> getDataStore() throws IOException {
        DataStore datastore;
        if (this.dataStore != null) {
            return this.dataStore;
        }
        FileDataStoreFactory factory = new FileDataStoreFactory(new File(DATASTORE_DIR));
        this.dataStore = datastore = factory.getDataStore("StoredCredential");
        return datastore;
    }

    public String getUserId(HttpServletRequest req) throws ServletException, IOException {
        return USERID;
    }

    public Credential getCredential() throws IOException {
        Credential cred;
        if (this.flow == null) {
            this.flow = this.initializeFlow();
            if (this.flow == null) {
                throw new IOException();
            }
        }
        if ((cred = this.flow.loadCredential(USERID)) == null) {
            throw new IOException();
        }
        this.logCredential(cred);
        if (cred.getExpirationTimeMilliseconds() <= System.currentTimeMillis()) {
            logger.info("expired access token");
            if (!cred.refreshToken()) {
                logger.error("failed refresh token");
            }
            this.logCredential(cred);
        }
        return cred;
    }

    public void deleteCredential() {
        try {
            this.getDataStore().delete(USERID);
        }
        catch (IOException e) {
            logger.error("occur exception", (Throwable)e);
        }
    }

    public boolean isValidCredential(Credential cred) {
        return cred != null && cred.getAccessToken() != null && cred.getRefreshToken() != null;
    }

    public void logCredential(Credential cred) {
        if (cred == null) {
            logger.info("credential is null");
            return;
        }
        String accessToken = cred.getAccessToken();
        if (accessToken == null) {
            logger.info("accessToken is null");
        }
        if (cred.getRefreshToken() == null) {
            logger.info("refreshToken is null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("accessToken " + accessToken);
            logger.debug("refreshToken " + cred.getRefreshToken());
            logger.debug("expirationTimeMilliseconds " + cred.getExpirationTimeMilliseconds());
            if (cred.getExpirationTimeMilliseconds() != null) {
                logger.debug("expirationTime " + new Date(cred.getExpirationTimeMilliseconds()));
            }
        }
    }

    public Map<String, Object> getCredentialInfo() throws GoogleOAuth2Exception {
        Credential cred;
        if (!this.getClientSecretFile().canRead()) {
            throw new GoogleOAuth2Exception(CANNNOT_READ_CLIENTSECRET_JFCERRORKEY);
        }
        try {
            cred = this.getCredential();
        }
        catch (IOException e) {
            logger.info("occur exception " + e.getClass().getName() + " : " + e.getMessage());
            logger.debug("occur exception ", (Throwable)e);
            throw new GoogleOAuth2Exception("error.GoogleOAuth2Util.not_found_credential");
        }
        if (!this.isValidCredential(cred)) {
            throw new GoogleOAuth2Exception("error.GoogleOAuth2Util.not_valid_credential");
        }
        UserInfo userinfo = null;
        try {
            userinfo = this.getUserInfo(cred.getAccessToken());
        }
        catch (IOException e) {
            logger.info("occur exception " + e.getClass().getName() + " : " + e.getMessage());
            logger.debug("occur exception", (Throwable)e);
        }
        if (userinfo == null) {
            throw new GoogleOAuth2Exception("error.GoogleOAuth2Util.cant_use_credential");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("credential", cred);
        map.put("userinfo", userinfo);
        map.put("email", userinfo.email);
        map.put("accessToken", cred.getAccessToken());
        return map;
    }

    public String[] getXOAuth2UserAccessToken(ActionParameter p, String mailhost) throws GoogleOAuth2Exception {
        if (mailhost == null || !mailhost.equals("smtp.gmail.com")) {
            return null;
        }
        Map<String, Object> map = this.getCredentialInfo();
        String[] sa = new String[]{(String)map.get("email"), (String)map.get("accessToken")};
        return sa;
    }

    public static class UserInfo {
        public String id;
        public String email;
        public boolean verified_email;
        public String name;
        public String given_name;
        public String family_name;
        public String picture;

        public UserInfo() {
        }

        public UserInfo(String id, String email, boolean verified_email, String name, String given_name, String family_name, String picture) {
            this.id = id;
            this.email = email;
            this.verified_email = verified_email;
            this.name = name;
            this.given_name = given_name;
            this.family_name = family_name;
            this.picture = picture;
        }

        public String toString() {
            return "{ id:" + this.id + ", email:" + this.email + ", verified_email:" + this.verified_email + ", name:" + this.name + ", given_name:" + this.given_name + ", family_name:" + this.family_name + ", picture:" + this.picture + " }";
        }
    }

    public static class GoogleOAuth2Exception
    extends Exception {
        GoogleOAuth2Exception(String msg) {
            super(msg);
        }
    }
}

