/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import jp.jasminesoft.jfc.textsearch.CJKAndStandardTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;

public class CJKAndStandardAnalyzer
extends Analyzer {
    private Set stopSet;
    private boolean replaceInvalidAcronym = defaultReplaceInvalidAcronym;
    private static boolean defaultReplaceInvalidAcronym;
    private static final String[] STOP_WORDS;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;

    public static boolean getDefaultReplaceInvalidAcronym() {
        return defaultReplaceInvalidAcronym;
    }

    public static void setDefaultReplaceInvalidAcronym(boolean replaceInvalidAcronym) {
        defaultReplaceInvalidAcronym = replaceInvalidAcronym;
    }

    public CJKAndStandardAnalyzer() {
        this(STOP_WORDS);
    }

    public CJKAndStandardAnalyzer(Set stopWords) {
        this.stopSet = stopWords;
    }

    public CJKAndStandardAnalyzer(String[] stopWords) {
        this.stopSet = StopFilter.makeStopSet((String[])stopWords);
    }

    public CJKAndStandardAnalyzer(File stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet((File)stopwords);
    }

    public CJKAndStandardAnalyzer(Reader stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet((Reader)stopwords);
    }

    public CJKAndStandardAnalyzer(boolean replaceInvalidAcronym) {
        this(STOP_WORDS);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public CJKAndStandardAnalyzer(Set stopWords, boolean replaceInvalidAcronym) {
        this.stopSet = stopWords;
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public CJKAndStandardAnalyzer(String[] stopWords, boolean replaceInvalidAcronym) {
        this.stopSet = StopFilter.makeStopSet((String[])stopWords);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public CJKAndStandardAnalyzer(File stopwords, boolean replaceInvalidAcronym) throws IOException {
        this.stopSet = WordlistLoader.getWordSet((File)stopwords);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public CJKAndStandardAnalyzer(Reader stopwords, boolean replaceInvalidAcronym) throws IOException {
        this.stopSet = WordlistLoader.getWordSet((Reader)stopwords);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        CJKAndStandardTokenizer tokenizer = new CJKAndStandardTokenizer(reader, this.replaceInvalidAcronym);
        tokenizer.setMaxTokenLength(this.maxTokenLength);
        StandardFilter result = new StandardFilter((TokenStream)tokenizer);
        result = new LowerCaseFilter((TokenStream)result);
        boolean enablePositionIncrements = false;
        result = new StopFilter(enablePositionIncrements, (TokenStream)result, this.stopSet);
        return result;
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            this.setPreviousTokenStream(streams);
            streams.tokenStream = new CJKAndStandardTokenizer(reader);
            streams.filteredTokenStream = new StandardFilter((TokenStream)streams.tokenStream);
            streams.filteredTokenStream = new LowerCaseFilter(streams.filteredTokenStream);
            boolean enablePositionIncrements = false;
            streams.filteredTokenStream = new StopFilter(enablePositionIncrements, streams.filteredTokenStream, this.stopSet);
        } else {
            streams.tokenStream.reset(reader);
        }
        return streams.filteredTokenStream;
    }

    static {
        STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS_SET.toArray(new String[0]);
    }

    private static final class SavedStreams {
        CJKAndStandardTokenizer tokenStream;
        TokenStream filteredTokenStream;

        private SavedStreams() {
        }
    }
}

