/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CharCounter {
    private static final Logger logger = LogManager.getLogger(CharCounter.class);
    private int limit = 33000000;
    public static final int NO_LIMIT = -1;
    private int count = 0;
    private boolean isOverLimitWarnned = false;

    public CharCounter() {
    }

    public CharCounter(CharCounter cc) {
        this.limit = cc.limit;
        this.count = cc.count;
        this.isOverLimitWarnned = cc.isOverLimitWarnned;
    }

    public CharCounter(CharCounter cc, boolean isOverLimitWarnned) {
        this(cc);
        this.isOverLimitWarnned = isOverLimitWarnned;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int l) {
        this.limit = l;
    }

    public boolean isOverLimit() {
        if (this.limit == -1) {
            return false;
        }
        return this.count >= this.limit;
    }

    public int getCount() {
        return this.count;
    }

    public String countChar(String s) {
        if (s == null) {
            logger.debug("text is null ");
            return "";
        }
        if (this.limit == -1) {
            this.count += s.length();
            return s;
        }
        if (this.count >= this.limit) {
            if (!this.isOverLimitWarnned) {
                this.isOverLimitWarnned = true;
                logger.warn("text extracted exceeds the limit " + this.limit);
                logger.warn("max memory is " + Runtime.getRuntime().maxMemory());
            }
            return "";
        }
        if (this.count + s.length() >= this.limit) {
            if (!this.isOverLimitWarnned) {
                this.isOverLimitWarnned = true;
                logger.warn("text extracted exceeds the limit " + this.limit);
                logger.warn("max memory is " + Runtime.getRuntime().maxMemory());
            }
            long subslength = this.limit - this.count;
            this.count = this.limit;
            return s.substring(0, (int)subslength);
        }
        this.count += s.length();
        return s;
    }
}

