/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import jp.co.antenna.dmc.v4.DMCTextInfoV4;
import jp.co.antenna.dmc.v4.DMCnativeV4;
import jp.jasminesoft.jfc.textsearch.CharCounter;
import jp.jasminesoft.jfc.textsearch.TextExtractor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextPorterTextExtractor
extends TextExtractor {
    private static final Logger logger = LogManager.getLogger((String)TextPorterTextExtractor.class.getName());

    @Override
    public String extract(CharCounter cc, String filename, File f) throws Exception {
        if (cc.isOverLimit()) {
            return "";
        }
        logger.debug("extract");
        try {
            TextExtractor.isExtractable(f);
        }
        catch (Exception e) {
            logger.warn("filename:" + f.getAbsolutePath());
            return "";
        }
        try {
            DMCTextInfoV4 txtinfo = new DMCTextInfoV4();
            txtinfo.getbBigEndian(1);
            txtinfo.getDefLangName("Japanese");
            txtinfo.getGroupName("Shift_JIS");
            ByteArrayOutputStream index = new ByteArrayOutputStream();
            DMCnativeV4.getTextStreamV4((File)f, (OutputStream)index, (DMCTextInfoV4)txtinfo);
            return cc.countChar(new String(index.toByteArray(), "Shift_JIS"));
        }
        catch (LinkageError e) {
            logger.error("LinkageError " + e.getMessage() + ". if NoClassDefFoundError occured, please check if dmcjava.jar is in $(APPNAME)/WEB-INF/lib ", (Throwable)e);
            return "";
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

