/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.th;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import jp.jasminesoft.jfc.th.JfcIfLogonTagProcessor;
import jp.jasminesoft.jfc.th.JfcUtil;
import jp.jasminesoft.jfc.th.JfcXslNameAttributeTagProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.dialect.AbstractProcessorDialect;
import org.thymeleaf.dialect.IExpressionObjectDialect;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.standard.processor.StandardXmlNsTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;

public class JfcDialect
extends AbstractProcessorDialect
implements IExpressionObjectDialect {
    private static final String DIALECT_NAME = "JfcDialect";
    private static final String DIALECT_PREFIX = "jfc";
    private static final String EXPRESSION_NAME = "jfc";
    @Autowired(required=false)
    private ServletContext servletContext;

    public JfcDialect() {
        this("jfc");
    }

    public JfcDialect(String dialectPrefix) {
        super(DIALECT_NAME, dialectPrefix, 1000);
    }

    public Set<IProcessor> getProcessors(String dialectPrefix) {
        HashSet<IProcessor> processors = new HashSet<IProcessor>();
        processors.add((IProcessor)new StandardXmlNsTagProcessor(TemplateMode.HTML, dialectPrefix));
        processors.add((IProcessor)new JfcXslNameAttributeTagProcessor(dialectPrefix, this.servletContext));
        processors.add((IProcessor)new JfcIfLogonTagProcessor(dialectPrefix, "ifLogon", 1000));
        return processors;
    }

    public IExpressionObjectFactory getExpressionObjectFactory() {
        return new IExpressionObjectFactory(){

            public Set<String> getAllExpressionObjectNames() {
                return Collections.singleton("jfc");
            }

            public Object buildObject(IExpressionContext context, String expressionObjectName) {
                return new JfcUtil();
            }

            public boolean isCacheable(String expressionObjectName) {
                return false;
            }
        };
    }
}

